/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.base.Notification;

public final class EntityAndPendingNotifications<BE, E extends AbstractElement<?, ?>> {
    private final BE entityRepresentation;
    private final E entity;
    private final List<Notification<?, ?>> notifications;

    EntityAndPendingNotifications(BE entityRepresentation, E entity, Action<E, E> action) {
        this(entityRepresentation, entity, new Notification<E, E>(entity, entity, action));
    }

    <C> EntityAndPendingNotifications(BE entityRepresentation, E entity, C actionContext, Action<C, E> action) {
        this(entityRepresentation, entity, new Notification<C, E>(actionContext, entity, action));
    }

    EntityAndPendingNotifications(BE entityRepresentation, E entity, Notification<?, ?> ... notifications) {
        this.entityRepresentation = entityRepresentation;
        this.entity = entity;
        this.notifications = new ArrayList();
        Collections.addAll(this.notifications, notifications);
    }

    EntityAndPendingNotifications(BE entityRepresentation, E entity, Iterable<Notification<?, ?>> notifications) {
        this.entityRepresentation = entityRepresentation;
        this.entity = entity;
        this.notifications = new ArrayList();
        notifications.forEach(this.notifications::add);
    }

    public BE getEntityRepresentation() {
        return this.entityRepresentation;
    }

    public E getEntity() {
        return this.entity;
    }

    public List<Notification<?, ?>> getNotifications() {
        return this.notifications;
    }
}

