/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.cmd;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.ws.api.tools.WSContractConsumer;
import org.jboss.ws.tools.cmd.Log4JUtil;
import org.jboss.ws.tools.cmd.Log4jOutputStream;
import org.jboss.ws.tools.cmd.SecurityActions;

public class WSConsume {
    private List<File> bindingFiles = new ArrayList<File>();
    private File outputDir = new File("output");
    private boolean generateSource;
    private File catalog;
    private String targetPackage;
    private String wsdlLocation;
    private String encoding;
    private boolean quiet;
    private boolean verbose;
    private boolean loadConsumer;
    private boolean extension;
    private boolean additionalHeaders;
    private boolean noCompile;
    private File sourceDir;
    private File clientJar;
    private String target;
    public static final String PROGRAM_NAME = SecurityActions.getSystemProperty("program.name", WSConsume.class.getName());

    public static void main(String[] args) {
        ClassLoader origLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(WSConsume.class.getClassLoader());
            WSConsume.mainInternal(args);
        }
        finally {
            SecurityActions.setContextClassLoader(origLoader);
        }
    }

    private static void mainInternal(String[] args) {
        WSConsume importer = new WSConsume();
        URL wsdl = importer.parseArguments(args);
        System.exit(importer.importServices(wsdl));
    }

    private URL parseArguments(String[] args) {
        int wsdlPos;
        int c;
        String shortOpts = "b:c:p:w:d:o:s:t:j:khqvlnea";
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("binding", 1, null, 98), new LongOpt("catalog", 1, null, 99), new LongOpt("package", 1, null, 112), new LongOpt("wsdlLocation", 1, null, 119), new LongOpt("output", 1, null, 111), new LongOpt("source", 1, null, 115), new LongOpt("target", 1, null, 116), new LongOpt("keep", 0, null, 107), new LongOpt("help", 0, null, 104), new LongOpt("quiet", 0, null, 113), new LongOpt("verbose", 0, null, 118), new LongOpt("nocompile", 0, null, 110), new LongOpt("extension", 0, null, 101), new LongOpt("additionalHeaders", 0, null, 97), new LongOpt("load-consumer", 0, null, 108), new LongOpt("clientjar", 1, null, 106), new LongOpt("encoding", 1, null, 100)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, shortOpts, longOpts);
        while ((c = getopt.getopt()) != -1) {
            switch (c) {
                case 98: {
                    this.bindingFiles.add(new File(getopt.getOptarg()));
                    break;
                }
                case 107: {
                    this.generateSource = true;
                    break;
                }
                case 99: {
                    this.catalog = new File(getopt.getOptarg());
                    break;
                }
                case 112: {
                    this.targetPackage = getopt.getOptarg();
                    break;
                }
                case 119: {
                    this.wsdlLocation = getopt.getOptarg();
                    break;
                }
                case 100: {
                    this.encoding = getopt.getOptarg();
                    break;
                }
                case 111: {
                    this.outputDir = new File(getopt.getOptarg());
                    break;
                }
                case 115: {
                    this.sourceDir = new File(getopt.getOptarg());
                    break;
                }
                case 106: {
                    this.clientJar = new File(getopt.getOptarg());
                    break;
                }
                case 116: {
                    this.target = getopt.getOptarg();
                    break;
                }
                case 113: {
                    this.quiet = true;
                    break;
                }
                case 118: {
                    this.verbose = true;
                    break;
                }
                case 108: {
                    this.loadConsumer = true;
                    break;
                }
                case 101: {
                    this.extension = true;
                    break;
                }
                case 97: {
                    this.additionalHeaders = true;
                    break;
                }
                case 110: {
                    this.noCompile = true;
                    break;
                }
                case 104: {
                    WSConsume.printHelp();
                    System.exit(0);
                }
                case 63: {
                    System.exit(1);
                }
            }
        }
        if (this.loadConsumer) {
            WSContractConsumer importer = WSContractConsumer.newInstance();
            System.out.println("WSContractConsumer instance: " + importer.getClass().getCanonicalName());
            System.exit(0);
        }
        if ((wsdlPos = getopt.getOptind()) >= args.length) {
            System.err.println("Error: WSDL URL was not specified!");
            WSConsume.printHelp();
            System.exit(1);
        }
        URL url = null;
        try {
            try {
                url = new URL(args[wsdlPos]);
            }
            catch (MalformedURLException e) {
                File file = new File(args[wsdlPos]);
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Error: Invalid URI: " + args[wsdlPos]);
            System.exit(1);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int importServices(URL wsdl) {
        WSContractConsumer consumer = WSContractConsumer.newInstance();
        consumer.setGenerateSource(this.generateSource);
        consumer.setOutputDirectory(this.outputDir);
        consumer.setExtension(this.extension);
        consumer.setAdditionalHeaders(this.additionalHeaders);
        if (this.sourceDir != null) {
            consumer.setSourceDirectory(this.sourceDir);
        }
        if (this.clientJar != null) {
            consumer.setClientJar(this.clientJar);
        }
        boolean cleanPS = false;
        PrintStream ps = System.out;
        if (!this.quiet) {
            if (Log4JUtil.isLog4jConfigurationAvailable()) {
                ps = new PrintStream(new Log4jOutputStream((Category)Logger.getLogger((String)"WSConsume"), (Priority)Level.INFO));
                cleanPS = true;
            } else {
                ps.println("Could not find log4j.xml configuration, logging to console.\n");
            }
            consumer.setMessageStream(ps);
        }
        if (this.catalog != null) {
            if (this.catalog.exists() && this.catalog.isFile()) {
                consumer.setCatalog(this.catalog);
            } else {
                System.err.println("Warning: catalog file not found: " + this.catalog);
            }
        }
        if (this.targetPackage != null) {
            consumer.setTargetPackage(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            consumer.setWsdlLocation(this.wsdlLocation);
        }
        if (this.encoding != null) {
            consumer.setEncoding(this.encoding);
        }
        if (this.bindingFiles != null && this.bindingFiles.size() > 0) {
            consumer.setBindingFiles(this.bindingFiles);
        }
        if (this.target != null) {
            consumer.setTarget(this.target);
        }
        if (this.noCompile) {
            consumer.setNoCompile(this.noCompile);
        }
        try {
            consumer.consume(wsdl);
            int n = 0;
            return n;
        }
        catch (Throwable t) {
            System.err.println("Error: Could not import. (use --verbose to see full traces)");
            if (!this.verbose) {
                String message = t.getMessage();
                if (message == null) {
                    message = t.getClass().getSimpleName();
                }
                System.err.println("Error: " + message);
            } else {
                t.printStackTrace(System.err);
            }
        }
        finally {
            if (cleanPS) {
                ps.close();
            }
        }
        return 1;
    }

    private static void printHelp() {
        PrintStream out = System.out;
        out.println("WSConsumeTask is a cmd line tool that generates portable JAX-WS artifacts from a WSDL file.\n");
        out.println("usage: " + PROGRAM_NAME + " [options] <wsdl-url>\n");
        out.println("options: ");
        out.println("    -h, --help                  Show this help message");
        out.println("    -b, --binding=<file>        One or more JAX-WS or JAXB binding files ");
        out.println("    -k, --keep                  Keep/Generate Java source");
        out.println("    -c  --catalog=<file>        Oasis XML Catalog file for entity resolution");
        out.println("    -j  --clientjar=<name>      Create a jar file of the generated artifacts for calling the webservice");
        out.println("    -p  --package=<name>        The target package for generated source");
        out.println("    -w  --wsdlLocation=<loc>    Value to use for @WebService.wsdlLocation");
        out.println("    -o, --output=<directory>    The directory to put generated artifacts");
        out.println("    -s, --source=<directory>    The directory to put Java source");
        out.println("    -t, --target=<2.1|2.2>      The JAX-WS specification target");
        out.println("    -q, --quiet                 Be somewhat more quiet");
        out.println("    -v, --verbose               Show full exception stack traces");
        out.println("    -l, --load-consumer         Load the consumer and exit (debug utility)");
        out.println("    -e, --extension             Enable SOAP 1.2 binding extension");
        out.println("    -a, --additionalHeaders     Enable processing of implicit SOAP headers");
        out.println("    -d  --encoding=<charset>    The charset encoding to use for generated sources");
        out.println("    -n, --nocompile             Do not compile generated sources");
        out.flush();
    }
}

