/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.RemoteAsyncInvocationCancelStatusService;
import org.jboss.as.ejb3.remote.protocol.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;

class InvocationCancellationMessageHandler
extends AbstractMessageHandler {
    private final RemoteAsyncInvocationCancelStatusService remoteAsyncInvocationCancelStatus;

    InvocationCancellationMessageHandler(RemoteAsyncInvocationCancelStatusService asyncInvocationCancelStatus) {
        this.remoteAsyncInvocationCancelStatus = asyncInvocationCancelStatus;
    }

    @Override
    public void processMessage(ChannelAssociation channelAssociation, InputStream inputStream) throws IOException {
        DataInputStream input = new DataInputStream(inputStream);
        short invocationToCancel = input.readShort();
        CancellationFlag cancellationFlag = this.remoteAsyncInvocationCancelStatus.getCancelStatus(invocationToCancel);
        if (cancellationFlag == null) {
            return;
        }
        cancellationFlag.set(true);
        EjbLogger.REMOTE_LOGGER.debugf("Invocation with id %s has been marked as cancelled, as requested", invocationToCancel);
    }
}

