/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.security;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;

public class GetAccessibleCopyOfMember<T extends AccessibleObject>
implements PrivilegedAction<T> {
    private static final String UNABLE_TO_OBTAIN_AN_ACCESSIBLE_COPY_OF = "Unable to obtain an accessible copy of ";
    private final T originalMember;

    public GetAccessibleCopyOfMember(T originalMember) {
        this.originalMember = originalMember;
    }

    public static <T extends AccessibleObject> T of(T member) {
        T copy = GetAccessibleCopyOfMember.copyMember(member);
        copy.setAccessible(true);
        return copy;
    }

    @Override
    public T run() {
        return GetAccessibleCopyOfMember.of(this.originalMember);
    }

    private static <T extends AccessibleObject> T copyMember(T originalMember) {
        Class<?> declaringClass = ((Member)((Object)originalMember)).getDeclaringClass();
        try {
            if (originalMember instanceof Field) {
                return (T)GetAccessibleCopyOfMember.copyField((Field)originalMember, declaringClass);
            }
            if (originalMember instanceof Constructor) {
                return (T)GetAccessibleCopyOfMember.copyConstructor((Constructor)originalMember, declaringClass);
            }
            if (originalMember instanceof Method) {
                return (T)GetAccessibleCopyOfMember.copyMethod((Method)originalMember, declaringClass);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(UNABLE_TO_OBTAIN_AN_ACCESSIBLE_COPY_OF + originalMember, e);
        }
        throw new IllegalArgumentException(UNABLE_TO_OBTAIN_AN_ACCESSIBLE_COPY_OF + originalMember);
    }

    private static Field copyField(Field field, Class<?> declaringClass) throws NoSuchFieldException {
        return declaringClass.getDeclaredField(field.getName());
    }

    private static Method copyMethod(Method method, Class<?> declaringClass) throws NoSuchMethodException {
        return declaringClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
    }

    private static Constructor<?> copyConstructor(Constructor<?> constructor, Class<?> declaringClass) throws NoSuchMethodException {
        return declaringClass.getDeclaredConstructor(constructor.getParameterTypes());
    }
}

