/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.cipher;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.cipher.Decoder;

public class Des3CbcHmacSha1KdDecoder
extends Decoder {
    private static final byte[] ZERO_IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};

    @Override
    public int blockSize() {
        return 8;
    }

    @Override
    public int checksumSize() {
        return 20;
    }

    @Override
    public int confounderSize() {
        return this.blockSize();
    }

    @Override
    public int keySize() {
        return 24;
    }

    @Override
    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws NegotiationException {
        byte[] ivec = new byte[this.blockSize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws NegotiationException {
        try {
            return this.decrypt(key, usage, ivec, cipher, 0, cipher.length);
        }
        catch (GeneralSecurityException e) {
            NegotiationException ne = new NegotiationException(e.getMessage());
            ne.initCause(e);
            throw ne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decrypt(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len) throws GeneralSecurityException {
        byte[] byArray;
        byte[] Ki;
        block9: {
            byte[] Ke = null;
            Ki = null;
            try {
                byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -86};
                Ke = this.dk(baseKey, constant);
                Cipher decCipher = this.getCipher(Ke, ivec, 2);
                int blockSize = decCipher.getBlockSize();
                int cksumSize = this.checksumSize();
                int cipherSize = len - cksumSize;
                byte[] decrypted = decCipher.doFinal(ciphertext, start, cipherSize);
                constant[4] = 85;
                Ki = this.dk(baseKey, constant);
                byte[] calculatedHmac = this.getHmac(Ki, decrypted);
                boolean cksumFailed = false;
                if (calculatedHmac.length >= cksumSize) {
                    for (int i = 0; i < cksumSize; ++i) {
                        if (calculatedHmac[i] == ciphertext[cipherSize + i]) continue;
                        cksumFailed = true;
                        break;
                    }
                }
                if (cksumFailed) {
                    throw new GeneralSecurityException("Checksum failed");
                }
                if (ivec != null && ivec.length == blockSize) {
                    System.arraycopy(ciphertext, start + cipherSize - blockSize, ivec, 0, blockSize);
                }
                byte[] plaintext = new byte[decrypted.length - blockSize];
                System.arraycopy(decrypted, blockSize, plaintext, 0, plaintext.length);
                byArray = plaintext;
                if (Ke == null) break block9;
            }
            catch (Throwable throwable) {
                if (Ke != null) {
                    Arrays.fill(Ke, 0, Ke.length, (byte)0);
                }
                if (Ki != null) {
                    Arrays.fill(Ki, 0, Ki.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(Ke, 0, Ke.length, (byte)0);
        }
        if (Ki != null) {
            Arrays.fill(Ki, 0, Ki.length, (byte)0);
        }
        return byArray;
    }

    protected Cipher getCipher(byte[] key, byte[] ivec, int mode) throws GeneralSecurityException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("desede");
        DESedeKeySpec spec = new DESedeKeySpec(key, 0);
        SecretKey secretKey = factory.generateSecret(spec);
        if (ivec == null) {
            ivec = ZERO_IV;
        }
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        IvParameterSpec encIv = new IvParameterSpec(ivec, 0, ivec.length);
        cipher.init(mode, (Key)secretKey, encIv);
        return cipher;
    }

    protected byte[] getHmac(byte[] key, byte[] msg) throws GeneralSecurityException {
        SecretKeySpec keyKi = new SecretKeySpec(key, "HmacSHA1");
        Mac m = Mac.getInstance("HmacSHA1");
        m.init(keyKi);
        return m.doFinal(msg);
    }

    protected byte[] randomToKey(byte[] in) {
        if (in.length != 21) {
            throw new IllegalArgumentException("input must be 168 bits");
        }
        byte[] one = Des3CbcHmacSha1KdDecoder.keyCorrection(Des3CbcHmacSha1KdDecoder.des3Expand(in, 0, 7));
        byte[] two = Des3CbcHmacSha1KdDecoder.keyCorrection(Des3CbcHmacSha1KdDecoder.des3Expand(in, 7, 14));
        byte[] three = Des3CbcHmacSha1KdDecoder.keyCorrection(Des3CbcHmacSha1KdDecoder.des3Expand(in, 14, 21));
        byte[] key = new byte[24];
        System.arraycopy(one, 0, key, 0, 8);
        System.arraycopy(two, 0, key, 8, 8);
        System.arraycopy(three, 0, key, 16, 8);
        return key;
    }

    byte[] dk(byte[] key, byte[] constant) throws GeneralSecurityException {
        return this.randomToKey(this.dr(key, constant));
    }

    private byte[] dr(byte[] key, byte[] constant) throws GeneralSecurityException {
        int len;
        Cipher encCipher = this.getCipher(key, null, 1);
        int blocksize = encCipher.getBlockSize();
        if (constant.length != blocksize) {
            constant = Des3CbcHmacSha1KdDecoder.nfold(constant, blocksize * 8);
        }
        byte[] toBeEncrypted = constant;
        int keybytes = this.getKeySeedLength() >> 3;
        byte[] rawkey = new byte[keybytes];
        for (int n = 0; n < keybytes; n += len) {
            byte[] cipherBlock = encCipher.doFinal(toBeEncrypted);
            len = keybytes - n <= cipherBlock.length ? keybytes - n : cipherBlock.length;
            System.arraycopy(cipherBlock, 0, rawkey, n, len);
            toBeEncrypted = cipherBlock;
        }
        return rawkey;
    }

    protected int getKeySeedLength() {
        return 168;
    }

    static byte[] nfold(byte[] in, int outbits) {
        int i;
        int inbits = in.length;
        int a = outbits >>= 3;
        int b = inbits;
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        int lcm = outbits * inbits / a;
        byte[] out = new byte[outbits];
        Arrays.fill(out, (byte)0);
        int thisbyte = 0;
        for (i = lcm - 1; i >= 0; --i) {
            int msbit = ((inbits << 3) - 1 + ((inbits << 3) + 13) * (i / inbits) + (inbits - i % inbits << 3)) % (inbits << 3);
            int bval = ((in[(inbits - 1 - (msbit >>> 3)) % inbits] & 0xFF) << 8 | in[(inbits - (msbit >>> 3)) % inbits] & 0xFF) >>> (msbit & 7) + 1 & 0xFF;
            thisbyte += bval;
            int oval = out[i % outbits] & 0xFF;
            out[i % outbits] = (byte)((thisbyte += oval) & 0xFF);
            thisbyte >>>= 8;
        }
        if (thisbyte != 0) {
            for (i = outbits - 1; i >= 0; --i) {
                out[i] = (byte)((thisbyte += out[i] & 0xFF) & 0xFF);
                thisbyte >>>= 8;
            }
        }
        return out;
    }

    private static byte[] des3Expand(byte[] input, int start, int end) {
        if (end - start != 7) {
            throw new IllegalArgumentException("Invalid length of DES Key Value:" + start + "," + end);
        }
        byte[] result = new byte[8];
        byte last = 0;
        System.arraycopy(input, start, result, 0, 7);
        int posn = 0;
        for (int i = start; i < end; ++i) {
            byte bit = (byte)(input[i] & 1);
            posn = (byte)(posn + 1);
            if (bit == 0) continue;
            last = (byte)(last | bit << posn);
        }
        result[7] = last;
        Des3CbcHmacSha1KdDecoder.setParityBit(result);
        return result;
    }

    private static void setParityBit(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            int bitCount = 0;
            for (int maskIndex = 0; maskIndex < PARITY_BIT_MASK.length; ++maskIndex) {
                if ((key[i] & PARITY_BIT_MASK[maskIndex]) != PARITY_BIT_MASK[maskIndex]) continue;
                ++bitCount;
            }
            key[i] = bitCount & true ? (byte)(key[i] & 0xFFFFFFFE) : (byte)(key[i] | 1);
        }
    }

    private static byte[] keyCorrection(byte[] key) {
        try {
            if (DESKeySpec.isWeak(key, 0)) {
                key[7] = (byte)(key[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return key;
    }

    @Override
    public byte[] decryptedData(byte[] data) {
        return data;
    }
}

