/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.web.core.IdentityParticipantStack;

public class IdentityServer
implements HttpSessionListener {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static int count = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            String val = System.getProperty("identity.server.log.count", "100");
            return Integer.parseInt(val);
        }
    });
    private static int activeSessionCount = 0;
    private IdentityParticipantStack stack = new STACK();

    public int getActiveSessionCount() {
        return activeSessionCount;
    }

    public IdentityParticipantStack stack() {
        return this.stack;
    }

    public void setStack(IdentityParticipantStack theStack) {
        this.stack = theStack;
    }

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        if (++activeSessionCount % count == 0) {
            logger.samlIdentityServerActiveSessionCount(activeSessionCount);
        }
        HttpSession session = sessionEvent.getSession();
        logger.samlIdentityServerSessionCreated(session.getId(), activeSessionCount);
        ServletContext servletContext = session.getServletContext();
        IdentityServer idserver = (IdentityServer)servletContext.getAttribute("IDENTITY_SERVER");
        if (idserver == null) {
            idserver = this;
            servletContext.setAttribute("IDENTITY_SERVER", (Object)this);
        }
        if (idserver != this) {
            throw logger.notEqualError(idserver.toString(), this.toString());
        }
        String id = sessionEvent.getSession().getId();
        this.stack.createSession(id);
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        String id = sessionEvent.getSession().getId();
        logger.samlIdentityServerSessionDestroyed(id, --activeSessionCount);
        this.stack.removeSession(id);
    }

    public static class STACK
    implements IdentityParticipantStack {
        private final ConcurrentHashMap<String, Stack<String>> sessionParticipantsMap = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, Set<String>> inTransitMap = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, Boolean> postBindingMap = new ConcurrentHashMap();

        @Override
        public String peek(String sessionID) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null) {
                return stack.peek();
            }
            return "";
        }

        @Override
        public String pop(String sessionID) {
            String result = null;
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null && !stack.isEmpty()) {
                result = stack.pop();
            }
            return result;
        }

        @Override
        public void register(String sessionID, String participant, boolean postBinding) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack == null) {
                stack = new Stack();
                this.sessionParticipantsMap.put(sessionID, stack);
            }
            if (!stack.contains(participant)) {
                stack.push(participant);
                this.postBindingMap.put(participant, postBinding);
            }
        }

        @Override
        public int getParticipants(String sessionID) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null) {
                return stack.size();
            }
            return 0;
        }

        @Override
        public boolean registerTransitParticipant(String sessionID, String participant) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet == null) {
                transitSet = new HashSet<String>();
                this.inTransitMap.put(sessionID, transitSet);
            }
            return transitSet.add(participant);
        }

        @Override
        public boolean deRegisterTransitParticipant(String sessionID, String participant) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet != null) {
                this.postBindingMap.remove(participant);
                return transitSet.remove(participant);
            }
            return false;
        }

        @Override
        public int getNumOfParticipantsInTransit(String sessionID) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet != null) {
                return transitSet.size();
            }
            return 0;
        }

        @Override
        public Boolean getBinding(String participant) {
            return this.postBindingMap.get(participant);
        }

        @Override
        public int totalSessions() {
            return ((ConcurrentHashMap.CollectionView)((Object)this.sessionParticipantsMap.keySet())).size();
        }

        @Override
        public void createSession(String id) {
            this.sessionParticipantsMap.put(id, new Stack());
            this.inTransitMap.put(id, new HashSet());
        }

        @Override
        public void removeSession(String id) {
            this.sessionParticipantsMap.remove(id);
            this.inTransitMap.remove(id);
        }
    }
}

