/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.AbstractBasicConfiguration;
import org.jboss.logmanager.config.ConfigAction;
import org.jboss.logmanager.config.LogContextConfigurationImpl;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.ObjectProducer;
import org.jboss.logmanager.config.ValueExpression;
import org.jboss.logmanager.config.ValueExpressionImpl;

final class LoggerConfigurationImpl
extends AbstractBasicConfiguration<Logger, LoggerConfigurationImpl>
implements LoggerConfiguration {
    private ValueExpression<String> filter;
    private ValueExpression<Boolean> useParentHandlers;
    private ValueExpression<String> level;
    private final List<String> handlerNames = new ArrayList<String>(0);

    LoggerConfigurationImpl(String name, LogContextConfigurationImpl configuration) {
        super(name, configuration, configuration.getLoggerRefs(), configuration.getLoggerConfigurations());
    }

    @Override
    public String getFilter() {
        return this.getFilterValueExpression().getResolvedValue();
    }

    @Override
    public ValueExpression<String> getFilterValueExpression() {
        return this.filter == null ? ValueExpression.NULL_STRING_EXPRESSION : this.filter;
    }

    @Override
    public void setFilter(String filter) {
        this.setFilter(ValueExpression.STRING_RESOLVER.resolve(filter));
    }

    @Override
    public void setFilter(String expression, String value) {
        this.setFilter(new ValueExpressionImpl<String>(expression, value));
    }

    private void setFilter(ValueExpression<String> valueExpression) {
        final ValueExpression<String> oldFilterName = this.filter;
        this.filter = valueExpression;
        final String filterName = valueExpression.getResolvedValue();
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<ObjectProducer>(){

            @Override
            public ObjectProducer validate() throws IllegalArgumentException {
                return configuration.resolveFilter(filterName);
            }

            @Override
            public void applyPreCreate(ObjectProducer param) {
            }

            @Override
            public void applyPostCreate(ObjectProducer param) {
                configuration.getLoggerRefs().get(LoggerConfigurationImpl.this.getName()).setFilter((Filter)param.getObject());
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.filter = oldFilterName;
            }
        });
    }

    @Override
    public Boolean getUseParentHandlers() {
        return this.getUseParentHandlersValueExpression().getResolvedValue();
    }

    @Override
    public ValueExpression<Boolean> getUseParentHandlersValueExpression() {
        return this.useParentHandlers == null ? ValueExpression.NULL_BOOLEAN_EXPRESSION : this.useParentHandlers;
    }

    @Override
    public void setUseParentHandlers(Boolean useParentHandlers) {
        this.setUseParentHandlers(new ValueExpressionImpl<Boolean>(null, useParentHandlers));
    }

    @Override
    public void setUseParentHandlers(String expression) {
        this.setUseParentHandlers(ValueExpression.BOOLEAN_RESOLVER.resolve(expression));
    }

    @Override
    public void setUseParentHandlers(String expression, Boolean value) {
        this.setUseParentHandlers(new ValueExpressionImpl<Boolean>(expression, value));
    }

    private void setUseParentHandlers(ValueExpression<Boolean> valueExpression) {
        final ValueExpression<Boolean> oldUseParentHandlers = this.useParentHandlers;
        this.useParentHandlers = valueExpression;
        final Boolean useParentHandlers = valueExpression.getResolvedValue();
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                if (useParentHandlers != null) {
                    configuration.getLoggerRefs().get(LoggerConfigurationImpl.this.getName()).setUseParentHandlers(useParentHandlers);
                }
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.useParentHandlers = oldUseParentHandlers;
            }
        });
    }

    @Override
    public String getLevel() {
        return this.getLevelValueExpression().getResolvedValue();
    }

    @Override
    public ValueExpression<String> getLevelValueExpression() {
        return this.level == null ? ValueExpression.NULL_STRING_EXPRESSION : this.level;
    }

    @Override
    public void setLevel(String level) {
        this.setLevelValueExpression(ValueExpression.STRING_RESOLVER.resolve(level));
    }

    @Override
    public void setLevel(String expression, String level) {
        this.setLevelValueExpression(new ValueExpressionImpl<String>(expression, level));
    }

    private void setLevelValueExpression(ValueExpression<String> expression) {
        final ValueExpression<String> oldLevel = this.level;
        this.level = expression;
        final String resolvedLevel = expression.getResolvedValue();
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Level>(){

            @Override
            public Level validate() throws IllegalArgumentException {
                return resolvedLevel == null ? null : configuration.getLogContext().getLevelForName(resolvedLevel);
            }

            @Override
            public void applyPreCreate(Level param) {
            }

            @Override
            public void applyPostCreate(Level param) {
                configuration.getLoggerRefs().get(LoggerConfigurationImpl.this.getName()).setLevel(param);
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.level = oldLevel;
            }
        });
    }

    @Override
    public List<String> getHandlerNames() {
        return new ArrayList<String>(this.handlerNames);
    }

    @Override
    public void setHandlerNames(String ... names) {
        final String[] oldHandlerNames = this.handlerNames.toArray(new String[this.handlerNames.size()]);
        this.handlerNames.clear();
        LinkedHashSet<String> strings = new LinkedHashSet<String>(Arrays.asList(names));
        this.handlerNames.addAll(strings);
        final String[] stringsArray = strings.toArray(new String[strings.size()]);
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                for (String name : stringsArray) {
                    if (configuration.getHandlerConfiguration(name) != null) continue;
                    throw new IllegalArgumentException(String.format("Handler \"%s\" is not found", name));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                Map<String, Logger> loggerRefs = configuration.getLoggerRefs();
                Logger logger2 = loggerRefs.get(LoggerConfigurationImpl.this.getName());
                int length = stringsArray.length;
                Handler[] handlers = new Handler[length];
                for (int i = 0; i < length; ++i) {
                    handlers[i] = handlerRefs.get(stringsArray[i]);
                }
                logger2.setHandlers(handlers);
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.handlerNames.clear();
                LoggerConfigurationImpl.this.handlerNames.addAll(Arrays.asList(oldHandlerNames));
            }
        });
    }

    @Override
    public void setHandlerNames(Collection<String> names) {
        this.setHandlerNames(names.toArray(new String[names.size()]));
    }

    @Override
    public boolean addHandlerName(final String name) {
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        if (this.handlerNames.contains(name)) {
            return false;
        }
        this.handlerNames.add(name);
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                if (configuration.getHandlerConfiguration(name) == null) {
                    throw new IllegalArgumentException(String.format("Handler \"%s\" is not found", name));
                }
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                Map<String, Logger> loggerRefs = configuration.getLoggerRefs();
                Logger logger2 = loggerRefs.get(LoggerConfigurationImpl.this.getName());
                logger2.addHandler(handlerRefs.get(name));
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.handlerNames.remove(name);
            }
        });
        return true;
    }

    @Override
    public boolean removeHandlerName(final String name) {
        final LogContextConfigurationImpl configuration = this.getConfiguration();
        if (!this.handlerNames.contains(name)) {
            return false;
        }
        final int index = this.handlerNames.indexOf(name);
        this.handlerNames.remove(index);
        configuration.addAction(new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
            }

            @Override
            public void applyPostCreate(Void param) {
                Map<String, Handler> handlerRefs = configuration.getHandlerRefs();
                Map<String, Logger> loggerRefs = configuration.getLoggerRefs();
                Logger logger2 = loggerRefs.get(LoggerConfigurationImpl.this.getName());
                logger2.removeHandler(handlerRefs.get(name));
            }

            @Override
            public void rollback() {
                LoggerConfigurationImpl.this.handlerNames.add(index, name);
            }
        });
        return true;
    }

    @Override
    ConfigAction<Void> getRemoveAction() {
        boolean useParentHandlers;
        Level level;
        Handler[] handlers;
        Filter filter;
        final String name = this.getName();
        final Logger refLogger = (Logger)this.refs.get(name);
        if (refLogger == null) {
            filter = null;
            handlers = null;
            level = null;
            useParentHandlers = true;
        } else {
            filter = refLogger.getFilter();
            handlers = refLogger.getHandlers();
            level = refLogger.getLevel();
            useParentHandlers = refLogger.getUseParentHandlers();
        }
        return new ConfigAction<Void>(){

            @Override
            public Void validate() throws IllegalArgumentException {
                return null;
            }

            @Override
            public void applyPreCreate(Void param) {
                LoggerConfigurationImpl.this.refs.remove(name);
            }

            @Override
            public void applyPostCreate(Void param) {
                if (refLogger != null) {
                    refLogger.setFilter(null);
                    refLogger.clearHandlers();
                    refLogger.setLevel(null);
                    refLogger.setUseParentHandlers(true);
                }
            }

            @Override
            public void rollback() {
                if (refLogger != null) {
                    refLogger.setFilter(filter);
                    if (handlers != null) {
                        refLogger.setHandlers(handlers);
                    }
                    refLogger.setLevel(level);
                    refLogger.setUseParentHandlers(useParentHandlers);
                    LoggerConfigurationImpl.this.configs.put(name, LoggerConfigurationImpl.this);
                }
                LoggerConfigurationImpl.this.clearRemoved();
            }
        };
    }
}

