/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.windows.Kernel32;
import oshi.jna.platform.windows.Psapi;
import oshi.software.os.OSProcess;
import oshi.software.os.windows.WindowsProcess;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsCentralProcessor.class);
    private static String processProperties = "Name,CommandLine,ExecutionState,ProcessID,ParentProcessId,ThreadCount,Priority,VirtualSize,WorkingSetSize,KernelModeTime,UserModeTime,CreationDate";
    private static WmiUtil.ValueType[] processPropertyTypes = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.DATETIME};
    private static final long TICKS_PER_MILLISECOND;

    public WindowsCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        String cpuRegistryRoot = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor";
        String[] processorIds = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor");
        if (processorIds.length > 0) {
            String cpuRegistryPath = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + processorIds[0];
            this.setVendor(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"VendorIdentifier"));
            this.setName(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"ProcessorNameString"));
            this.setIdentifier(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"Identifier"));
        }
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(sysinfo);
        if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 9 || sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 6) {
            this.setCpu64(true);
        } else if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 0) {
            this.setCpu64(false);
        }
    }

    @Override
    protected void calculateProcessorCounts() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] processors;
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(sysinfo);
        this.logicalProcessorCount = sysinfo.dwNumberOfProcessors.intValue();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION proc : processors = Kernel32Util.getLogicalProcessorInformation()) {
            if (proc.relationship != 0) continue;
            ++this.physicalProcessorCount;
        }
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[this.curTicks.length];
        WinBase.FILETIME lpIdleTime = new WinBase.FILETIME();
        WinBase.FILETIME lpKernelTime = new WinBase.FILETIME();
        WinBase.FILETIME lpUserTime = new WinBase.FILETIME();
        if (!Kernel32.INSTANCE.GetSystemTimes(lpIdleTime, lpKernelTime, lpUserTime)) {
            LOG.error("Failed to update system idle/kernel/user times. Error code: " + Native.getLastError());
            return ticks;
        }
        ticks[3] = WinBase.FILETIME.dateToFileTime((Date)lpIdleTime.toDate()) / 10000L;
        ticks[2] = WinBase.FILETIME.dateToFileTime((Date)lpKernelTime.toDate()) / 10000L - ticks[3];
        ticks[1] = 0L;
        ticks[0] = WinBase.FILETIME.dateToFileTime((Date)lpUserTime.toDate()) / 10000L;
        return ticks;
    }

    @Override
    public long getSystemIOWaitTicks() {
        return FormatUtil.getUnsignedInt(WmiUtil.selectUint32From(null, "Win32_PerfRawData_PerfDisk_LogicalDisk", "AvgDisksecPerTransfer", "WHERE Name=\"_Total\"").intValue()) / TICKS_PER_MILLISECOND;
    }

    @Override
    public long[] getSystemIrqTicks() {
        long[] ticks = new long[2];
        Map<String, List<String>> irq = WmiUtil.selectStringsFrom(null, "Win32_PerfRawData_Counters_ProcessorInformation", "PercentInterruptTime,PercentDPCTime", "WHERE Name=\"_Total\"");
        if (irq.get("PercentInterruptTime").size() > 0) {
            ticks[0] = ParseUtil.parseLongOrDefault(irq.get("PercentInterruptTime").get(0), 0L) / 10000L;
            ticks[1] = ParseUtil.parseLongOrDefault(irq.get("PercentDPCTime").get(0), 0L) / 10000L;
        }
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1) {
            throw new IllegalArgumentException("Must include at least one element.");
        }
        if (nelem > 3) {
            LOG.warn("Max elements of SystemLoadAverage is 3. " + nelem + " specified. Ignoring extra.");
            nelem = 3;
        }
        double[] average = new double[nelem];
        for (int i = 0; i < average.length; ++i) {
            average[i] = -1.0;
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][4];
        Map<String, List<String>> wmiTicks = WmiUtil.selectStringsFrom(null, "Win32_PerfRawData_Counters_ProcessorInformation", "Name,PercentIdleTime,PercentPrivilegedTime,PercentUserTime", "WHERE NOT Name LIKE \"%_Total\"");
        block0: for (int index = 0; index < wmiTicks.get("Name").size(); ++index) {
            for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
                String name = "0," + cpu;
                if (!wmiTicks.get("Name").get(index).equals(name)) continue;
                ticks[cpu][0] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentUserTime").get(index), 0L) / TICKS_PER_MILLISECOND;
                ticks[cpu][1] = 0L;
                ticks[cpu][2] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentPrivilegedTime").get(index), 0L) / TICKS_PER_MILLISECOND;
                ticks[cpu][3] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentIdleTime").get(index), 0L) / TICKS_PER_MILLISECOND;
                continue block0;
            }
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        return Kernel32.INSTANCE.GetTickCount64() / 1000L;
    }

    @Override
    public String getSystemSerialNumber() {
        if (this.cpuSerialNumber == null) {
            this.cpuSerialNumber = WmiUtil.selectStringFrom(null, "Win32_BIOS", "SerialNumber", null);
            if (this.cpuSerialNumber.equals("")) {
                this.cpuSerialNumber = WmiUtil.selectStringFrom(null, "Win32_Csproduct", "IdentifyingNumber", null);
            }
            if (this.cpuSerialNumber.equals("")) {
                this.cpuSerialNumber = "unknown";
            }
        }
        return this.cpuSerialNumber;
    }

    @Override
    public OSProcess[] getProcesses() {
        Map<String, List<Object>> procs = WmiUtil.selectObjectsFrom(null, "Win32_Process", processProperties, null, processPropertyTypes);
        List<OSProcess> procList = this.processMapToList(procs);
        return procList.toArray(new OSProcess[procList.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        Map<String, List<Object>> procs = WmiUtil.selectObjectsFrom(null, "Win32_Process", processProperties, String.format("WHERE ProcessId=%d", pid), processPropertyTypes);
        List<OSProcess> procList = this.processMapToList(procs);
        return procList.size() > 0 ? procList.get(0) : null;
    }

    private List<OSProcess> processMapToList(Map<String, List<Object>> procs) {
        long now = System.currentTimeMillis();
        ArrayList<OSProcess> procList = new ArrayList<OSProcess>();
        for (int p = 0; p < procs.get("Name").size(); ++p) {
            procList.add(new WindowsProcess((String)procs.get("Name").get(p), (String)procs.get("CommandLine").get(p), ((Long)procs.get("ExecutionState").get(p)).intValue(), ((Long)procs.get("ProcessID").get(p)).intValue(), ((Long)procs.get("ParentProcessId").get(p)).intValue(), ((Long)procs.get("ThreadCount").get(p)).intValue(), ((Long)procs.get("Priority").get(p)).intValue(), ParseUtil.parseLongOrDefault((String)procs.get("VirtualSize").get(p), 0L), ParseUtil.parseLongOrDefault((String)procs.get("WorkingSetSize").get(p), 0L), ParseUtil.parseLongOrDefault((String)procs.get("KernelModeTime").get(p), 0L) / 10000L, ParseUtil.parseLongOrDefault((String)procs.get("UserModeTime").get(p), 0L) / 10000L, (Long)procs.get("CreationDate").get(p), now));
        }
        return procList;
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getProcessCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ProcessCount.intValue();
    }

    @Override
    public int getThreadCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ThreadCount.intValue();
    }

    static {
        WinBase.FILETIME lpIdleTime = new WinBase.FILETIME();
        WinBase.FILETIME lpKernelTime = new WinBase.FILETIME();
        WinBase.FILETIME lpUserTime = new WinBase.FILETIME();
        if (!Kernel32.INSTANCE.GetSystemTimes(lpIdleTime, lpKernelTime, lpUserTime)) {
            LOG.error("Failed to init system idle/kernel/user times. Error code: " + Native.getLastError());
        }
        long mSec = (WinBase.FILETIME.dateToFileTime((Date)lpKernelTime.toDate()) + WinBase.FILETIME.dateToFileTime((Date)lpUserTime.toDate())) / 10000L;
        Map<String, List<String>> wmiTicks = WmiUtil.selectStringsFrom(null, "Win32_PerfRawData_Counters_ProcessorInformation", "PercentIdleTime,PercentPrivilegedTime,PercentUserTime", "WHERE Name=\"_Total\"");
        long ticks = 0L;
        if (wmiTicks.get("PercentIdleTime").size() > 0) {
            ticks = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentIdleTime").get(0), 0L) + ParseUtil.parseLongOrDefault(wmiTicks.get("PercentPrivilegedTime").get(0), 0L) + ParseUtil.parseLongOrDefault(wmiTicks.get("PercentUserTime").get(0), 0L);
        }
        TICKS_PER_MILLISECOND = ticks / mSec;
        LOG.debug("Ticks per millisecond: {}", (Object)TICKS_PER_MILLISECOND);
    }
}

