/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractSymmetricAsymmetricBinding;
import org.apache.wss4j.policy.model.EncryptionToken;
import org.apache.wss4j.policy.model.ProtectionToken;
import org.apache.wss4j.policy.model.SignatureToken;

public class SymmetricBinding
extends AbstractSymmetricAsymmetricBinding {
    private EncryptionToken encryptionToken;
    private SignatureToken signatureToken;
    private ProtectionToken protectionToken;

    public SymmetricBinding(SPConstants.SPVersion version, Policy nestedPolicy) {
        super(version, nestedPolicy);
        this.parseNestedPolicy(nestedPolicy, this);
    }

    public QName getName() {
        return this.getVersion().getSPConstants().getSymmetricBinding();
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new SymmetricBinding(this.getVersion(), nestedPolicy);
    }

    protected void parseNestedPolicy(Policy nestedPolicy, SymmetricBinding symmetricBinding) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (this.getVersion().getSPConstants().getEncryptionToken().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getEncryptionToken().getNamespaceURI().equals(assertionNamespace)) {
                    if (symmetricBinding.getEncryptionToken() != null || symmetricBinding.getProtectionToken() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    symmetricBinding.setEncryptionToken((EncryptionToken)assertion);
                    continue;
                }
                if (this.getVersion().getSPConstants().getSignatureToken().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getSignatureToken().getNamespaceURI().equals(assertionNamespace)) {
                    if (symmetricBinding.getSignatureToken() != null || symmetricBinding.getProtectionToken() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    symmetricBinding.setSignatureToken((SignatureToken)assertion);
                    continue;
                }
                if (!this.getVersion().getSPConstants().getProtectionToken().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getProtectionToken().getNamespaceURI().equals(assertionNamespace)) continue;
                if (symmetricBinding.getProtectionToken() != null || symmetricBinding.getEncryptionToken() != null || symmetricBinding.getSignatureToken() != null) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                symmetricBinding.setProtectionToken((ProtectionToken)assertion);
            }
        }
    }

    public EncryptionToken getEncryptionToken() {
        return this.encryptionToken;
    }

    protected void setEncryptionToken(EncryptionToken encryptionToken) {
        this.encryptionToken = encryptionToken;
    }

    public SignatureToken getSignatureToken() {
        return this.signatureToken;
    }

    protected void setSignatureToken(SignatureToken signatureToken) {
        this.signatureToken = signatureToken;
    }

    public ProtectionToken getProtectionToken() {
        return this.protectionToken;
    }

    protected void setProtectionToken(ProtectionToken protectionToken) {
        this.protectionToken = protectionToken;
    }
}

