/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;

public class RelationDescription {
    private final String fromPropertyName;
    private final RelationType relationType;
    private final String toEntityName;
    private final String mappedByPropertyName;
    private final boolean ignoreNotFound;
    private final IdMapper idMapper;
    private final PropertyMapper fakeBidirectionalRelationMapper;
    private final PropertyMapper fakeBidirectionalRelationIndexMapper;
    private final boolean insertable;
    private boolean bidirectional;

    public static RelationDescription toOne(String fromPropertyName, RelationType relationType, String toEntityName, String mappedByPropertyName, IdMapper idMapper, PropertyMapper fakeBidirectionalRelationMapper, PropertyMapper fakeBidirectionalRelationIndexMapper, boolean insertable, boolean ignoreNotFound) {
        return new RelationDescription(fromPropertyName, relationType, toEntityName, mappedByPropertyName, idMapper, fakeBidirectionalRelationMapper, fakeBidirectionalRelationIndexMapper, insertable, ignoreNotFound);
    }

    public static RelationDescription toMany(String fromPropertyName, RelationType relationType, String toEntityName, String mappedByPropertyName, IdMapper idMapper, PropertyMapper fakeBidirectionalRelationMapper, PropertyMapper fakeBidirectionalRelationIndexMapper, boolean insertable) {
        return new RelationDescription(fromPropertyName, relationType, toEntityName, mappedByPropertyName, idMapper, fakeBidirectionalRelationMapper, fakeBidirectionalRelationIndexMapper, insertable, false);
    }

    private RelationDescription(String fromPropertyName, RelationType relationType, String toEntityName, String mappedByPropertyName, IdMapper idMapper, PropertyMapper fakeBidirectionalRelationMapper, PropertyMapper fakeBidirectionalRelationIndexMapper, boolean insertable, boolean ignoreNotFound) {
        this.fromPropertyName = fromPropertyName;
        this.relationType = relationType;
        this.toEntityName = toEntityName;
        this.mappedByPropertyName = mappedByPropertyName;
        this.ignoreNotFound = ignoreNotFound;
        this.idMapper = idMapper;
        this.fakeBidirectionalRelationMapper = fakeBidirectionalRelationMapper;
        this.fakeBidirectionalRelationIndexMapper = fakeBidirectionalRelationIndexMapper;
        this.insertable = insertable;
        this.bidirectional = false;
    }

    public String getFromPropertyName() {
        return this.fromPropertyName;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public String getToEntityName() {
        return this.toEntityName;
    }

    public String getMappedByPropertyName() {
        return this.mappedByPropertyName;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public IdMapper getIdMapper() {
        return this.idMapper;
    }

    public PropertyMapper getFakeBidirectionalRelationMapper() {
        return this.fakeBidirectionalRelationMapper;
    }

    public PropertyMapper getFakeBidirectionalRelationIndexMapper() {
        return this.fakeBidirectionalRelationIndexMapper;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }
}

