/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.DynamicMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.common.SAML2Support;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicMetadataResolver
extends AbstractMetadataResolver
implements DynamicMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicMetadataResolver.class);
    private Timer taskTimer;
    private boolean createdOwnTaskTimer;
    @Duration
    @Positive
    private Long minCacheDuration;
    @Duration
    @Positive
    private Long maxCacheDuration;
    @Positive
    private Float refreshDelayFactor;
    @Duration
    @Positive
    private Long maxIdleEntityData;
    private boolean removeIdleEntityData;
    @Duration
    @Positive
    private Long cleanupTaskInterval;
    private BackingStoreCleanupSweeper cleanupTask;

    public AbstractDynamicMetadataResolver(@Nullable Timer backgroundTaskTimer) {
        if (backgroundTaskTimer == null) {
            this.taskTimer = new Timer(true);
            this.createdOwnTaskTimer = true;
        } else {
            this.taskTimer = backgroundTaskTimer;
        }
        this.minCacheDuration = 600000L;
        this.maxCacheDuration = 28800000L;
        this.refreshDelayFactor = Float.valueOf(0.75f);
        this.cleanupTaskInterval = 1800000L;
        this.maxIdleEntityData = 28800000L;
        this.removeIdleEntityData = true;
    }

    @Nonnull
    public Long getMinCacheDuration() {
        return this.minCacheDuration;
    }

    public void setMinCacheDuration(@Nonnull Long duration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.minCacheDuration = (Long)Constraint.isNotNull((Object)duration, (String)"Minimum cache duration may not be null");
    }

    @Nonnull
    public Long getMaxCacheDuration() {
        return this.maxCacheDuration;
    }

    public void setMaxCacheDuration(@Nonnull Long duration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.maxCacheDuration = (Long)Constraint.isNotNull((Object)duration, (String)"Maximum cache duration may not be null");
    }

    public Float getRefreshDelayFactor() {
        return this.refreshDelayFactor;
    }

    public void setRefreshDelayFactor(Float factor) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (factor.floatValue() <= 0.0f || factor.floatValue() >= 1.0f) {
            throw new IllegalArgumentException("Refresh delay factor must be a number between 0.0 and 1.0, exclusive");
        }
        this.refreshDelayFactor = factor;
    }

    public boolean isRemoveIdleEntityData() {
        return this.removeIdleEntityData;
    }

    public void setRemoveIdleEntityData(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.removeIdleEntityData = flag;
    }

    @Nonnull
    public Long getMaxIdleEntityData() {
        return this.maxIdleEntityData;
    }

    public void setMaxIdleEntityData(@Nonnull Long max) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.maxIdleEntityData = (Long)Constraint.isNotNull((Object)max, (String)"Max idle entity data may not be null");
    }

    @Nonnull
    public Long getCleanupTaskInterval() {
        return this.cleanupTaskInterval;
    }

    public void setCleanupTaskInterval(@Nonnull Long interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.cleanupTaskInterval = (Long)Constraint.isNotNull((Object)interval, (String)"Cleanup task interval may not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<EntityDescriptor> resolve(@Nonnull CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        EntityIdCriterion entityIdCriterion = (EntityIdCriterion)criteria.get(EntityIdCriterion.class);
        if (entityIdCriterion == null || Strings.isNullOrEmpty((String)entityIdCriterion.getEntityId())) {
            throw new ResolverException("Entity Id was not supplied in criteria set");
        }
        String entityID = StringSupport.trimOrNull((String)((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        this.log.debug("Attempting to resolve metadata for entityID: {}", (Object)entityID);
        EntityManagementData mgmtData = this.getBackingStore().getManagementData(entityID);
        Lock readLock = mgmtData.getReadWriteLock().readLock();
        try {
            readLock.lock();
            if (!this.shouldAttemptRefresh(mgmtData)) {
                List<EntityDescriptor> descriptors = this.lookupEntityID(entityID);
                if (!descriptors.isEmpty()) {
                    this.log.debug("Found requested metadata in backing store, returning");
                    List<EntityDescriptor> list = descriptors;
                    return list;
                }
                this.log.debug("Did not find requested metadata in backing store, will attempt to resolve dynamically");
            } else {
                this.log.debug("Metadata was indicated to be refreshed based on refresh trigger time");
            }
        }
        finally {
            readLock.unlock();
        }
        return this.resolveFromOriginSource(criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    protected Iterable<EntityDescriptor> resolveFromOriginSource(@Nonnull CriteriaSet criteria) throws ResolverException {
        String entityID = StringSupport.trimOrNull((String)((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        EntityManagementData mgmtData = this.getBackingStore().getManagementData(entityID);
        Lock writeLock = mgmtData.getReadWriteLock().writeLock();
        try {
            List<EntityDescriptor> descriptors;
            writeLock.lock();
            if (!this.shouldAttemptRefresh(mgmtData) && !(descriptors = this.lookupEntityID(entityID)).isEmpty()) {
                this.log.debug("Metadata was resolved and stored by another thread while this thread was waiting on the write lock");
                List<EntityDescriptor> list = descriptors;
                return list;
            }
            this.log.debug("Resolving metadata dynamically for entity ID: {}", (Object)entityID);
            XMLObject root = this.fetchFromOriginSource(criteria);
            if (root == null) {
                this.log.debug("No metadata was fetched from the origin source");
            } else {
                try {
                    this.processNewMetadata(root, entityID);
                }
                catch (FilterException e) {
                    this.log.error("Metadata filtering problem processing new metadata", (Throwable)e);
                }
            }
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        catch (IOException e) {
            this.log.error("Error fetching metadata from origin source", (Throwable)e);
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Nullable
    protected abstract XMLObject fetchFromOriginSource(@Nonnull CriteriaSet var1) throws IOException;

    @Override
    @Nonnull
    @NonnullElements
    protected List<EntityDescriptor> lookupEntityID(@Nonnull String entityID) throws ResolverException {
        this.getBackingStore().getManagementData(entityID).recordEntityAccess();
        return super.lookupEntityID(entityID);
    }

    @Nonnull
    protected void processNewMetadata(@Nonnull XMLObject root, @Nonnull String expectedEntityID) throws FilterException {
        XMLObject filteredMetadata = this.filterMetadata(root);
        if (filteredMetadata == null) {
            this.log.info("Metadata filtering process produced a null document, resulting in an empty data set");
            return;
        }
        if (filteredMetadata instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)filteredMetadata;
            if (!Objects.equals(entityDescriptor.getEntityID(), expectedEntityID)) {
                this.log.warn("New metadata's entityID '{}' does not match expected entityID '{}', will not process", (Object)entityDescriptor.getEntityID(), (Object)expectedEntityID);
                return;
            }
            this.preProcessEntityDescriptor(entityDescriptor, this.getBackingStore());
        } else {
            this.log.warn("Document root was not an EntityDescriptor: {}", (Object)root.getClass().getName());
        }
    }

    @Override
    protected void preProcessEntityDescriptor(@Nonnull EntityDescriptor entityDescriptor, @Nonnull AbstractMetadataResolver.EntityBackingStore backingStore) {
        String entityID = StringSupport.trimOrNull((String)entityDescriptor.getEntityID());
        this.removeByEntityID(entityID, backingStore);
        super.preProcessEntityDescriptor(entityDescriptor, backingStore);
        DynamicEntityBackingStore dynamicBackingStore = (DynamicEntityBackingStore)backingStore;
        EntityManagementData mgmtData = dynamicBackingStore.getManagementData(entityID);
        DateTime now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        this.log.debug("For metadata expiration and refresh computation, 'now' is : {}", (Object)now);
        mgmtData.setLastUpdateTime(now);
        mgmtData.setExpirationTime(this.computeExpirationTime(entityDescriptor, now));
        this.log.debug("Computed metadata expiration time: {}", (Object)mgmtData.getExpirationTime());
        mgmtData.setRefreshTriggerTime(this.computeRefreshTriggerTime(mgmtData.getExpirationTime(), now));
        this.log.debug("Computed refresh trigger time: {}", (Object)mgmtData.getRefreshTriggerTime());
    }

    @Nonnull
    protected DateTime computeExpirationTime(@Nonnull EntityDescriptor entityDescriptor, @Nonnull DateTime now) {
        DateTime lowerBound = now.toDateTime((Chronology)ISOChronology.getInstanceUTC()).plus(this.getMinCacheDuration().longValue());
        DateTime expiration = SAML2Support.getEarliestExpiration((XMLObject)entityDescriptor, (DateTime)now.plus(this.getMaxCacheDuration().longValue()), (DateTime)now);
        if (expiration.isBefore((ReadableInstant)lowerBound)) {
            expiration = lowerBound;
        }
        return expiration;
    }

    @Nonnull
    protected DateTime computeRefreshTriggerTime(@Nullable DateTime expirationTime, @Nonnull DateTime nowDateTime) {
        long refreshDelay;
        DateTime nowDateTimeUTC = nowDateTime.toDateTime((Chronology)ISOChronology.getInstanceUTC());
        long now = nowDateTimeUTC.getMillis();
        long expireInstant = 0L;
        if (expirationTime != null) {
            expireInstant = expirationTime.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        }
        if ((refreshDelay = (long)((float)(expireInstant - now) * this.getRefreshDelayFactor().floatValue())) < this.getMinCacheDuration()) {
            refreshDelay = this.getMinCacheDuration();
        }
        return nowDateTimeUTC.plus(refreshDelay);
    }

    protected boolean shouldAttemptRefresh(@Nonnull EntityManagementData mgmtData) {
        DateTime now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        return now.isAfter((ReadableInstant)mgmtData.getRefreshTriggerTime());
    }

    @Override
    @Nonnull
    protected DynamicEntityBackingStore createNewBackingStore() {
        return new DynamicEntityBackingStore();
    }

    @Override
    @NonnullAfterInit
    protected DynamicEntityBackingStore getBackingStore() {
        return (DynamicEntityBackingStore)super.getBackingStore();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        this.setBackingStore(this.createNewBackingStore());
        this.cleanupTask = new BackingStoreCleanupSweeper();
        this.taskTimer.schedule((TimerTask)this.cleanupTask, 60000L, (long)this.getCleanupTaskInterval());
    }

    @Override
    protected void doDestroy() {
        this.cleanupTask.cancel();
        if (this.createdOwnTaskTimer) {
            this.taskTimer.cancel();
        }
        this.cleanupTask = null;
        this.taskTimer = null;
        super.doDestroy();
    }

    protected class BackingStoreCleanupSweeper
    extends TimerTask {
        private final Logger log = LoggerFactory.getLogger(BackingStoreCleanupSweeper.class);

        protected BackingStoreCleanupSweeper() {
        }

        @Override
        public void run() {
            if (AbstractDynamicMetadataResolver.this.isDestroyed() || !AbstractDynamicMetadataResolver.this.isInitialized()) {
                this.log.debug("BackingStoreCleanupSweeper will not run because: inited: {}, destroyed: {}", (Object)AbstractDynamicMetadataResolver.this.isInitialized(), (Object)AbstractDynamicMetadataResolver.this.isDestroyed());
                return;
            }
            this.removeExpiredAndIdleMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeExpiredAndIdleMetadata() {
            DateTime now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
            DateTime earliestValidLastAccessed = now.minus(AbstractDynamicMetadataResolver.this.getMaxIdleEntityData().longValue());
            DynamicEntityBackingStore backingStore = AbstractDynamicMetadataResolver.this.getBackingStore();
            Map<String, List<EntityDescriptor>> indexedDescriptors = backingStore.getIndexedDescriptors();
            for (String entityID : indexedDescriptors.keySet()) {
                EntityManagementData mgmtData = backingStore.getManagementData(entityID);
                Lock writeLock = mgmtData.getReadWriteLock().writeLock();
                try {
                    writeLock.lock();
                    if (!this.isRemoveData(mgmtData, now, earliestValidLastAccessed)) continue;
                    AbstractDynamicMetadataResolver.this.removeByEntityID(entityID, backingStore);
                    backingStore.removeManagementData(entityID);
                }
                finally {
                    writeLock.unlock();
                }
            }
        }

        private boolean isRemoveData(EntityManagementData mgmtData, DateTime now, DateTime earliestValidLastAccessed) {
            if (AbstractDynamicMetadataResolver.this.isRemoveIdleEntityData() && mgmtData.getLastAccessedTime().isBefore((ReadableInstant)earliestValidLastAccessed)) {
                this.log.debug("Entity metadata exceeds maximum idle time, removing: {}", (Object)mgmtData.getEntityID());
                return true;
            }
            if (now.isAfter((ReadableInstant)mgmtData.getExpirationTime())) {
                this.log.debug("Entity metadata is expired, removing: {}", (Object)mgmtData.getEntityID());
                return true;
            }
            return false;
        }
    }

    protected class EntityManagementData {
        private String entityID;
        private DateTime lastUpdateTime;
        private DateTime expirationTime;
        private DateTime refreshTriggerTime;
        private DateTime lastAccessedTime;
        private ReadWriteLock readWriteLock;

        protected EntityManagementData(String id) {
            this.entityID = (String)Constraint.isNotNull((Object)id, (String)"Entity ID was null");
            this.expirationTime = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus(AbstractDynamicMetadataResolver.this.getMaxCacheDuration().longValue());
            this.refreshTriggerTime = new DateTime((Chronology)ISOChronology.getInstanceUTC()).plus(AbstractDynamicMetadataResolver.this.getMaxCacheDuration().longValue());
            this.lastAccessedTime = new DateTime((Chronology)ISOChronology.getInstanceUTC());
            this.readWriteLock = new ReentrantReadWriteLock(true);
        }

        @Nonnull
        public String getEntityID() {
            return this.entityID;
        }

        @Nullable
        public DateTime getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public void setLastUpdateTime(@Nonnull DateTime dateTime) {
            this.lastUpdateTime = dateTime;
        }

        @Nonnull
        public DateTime getExpirationTime() {
            return this.expirationTime;
        }

        public void setExpirationTime(@Nonnull DateTime dateTime) {
            this.expirationTime = (DateTime)Constraint.isNotNull((Object)dateTime, (String)"Expiration time may not be null");
        }

        @Nonnull
        public DateTime getRefreshTriggerTime() {
            return this.refreshTriggerTime;
        }

        public void setRefreshTriggerTime(@Nonnull DateTime dateTime) {
            this.refreshTriggerTime = (DateTime)Constraint.isNotNull((Object)dateTime, (String)"Refresh trigger time may not be null");
        }

        @Nonnull
        public DateTime getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void recordEntityAccess() {
            this.lastAccessedTime = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        }

        @Nonnull
        public ReadWriteLock getReadWriteLock() {
            return this.readWriteLock;
        }
    }

    protected class DynamicEntityBackingStore
    extends AbstractMetadataResolver.EntityBackingStore {
        private Map<String, EntityManagementData> mgmtDataMap;

        protected DynamicEntityBackingStore() {
            super(AbstractDynamicMetadataResolver.this);
            this.mgmtDataMap = new ConcurrentHashMap<String, EntityManagementData>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public EntityManagementData getManagementData(@Nonnull String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            EntityManagementData entityData = this.mgmtDataMap.get(entityID);
            if (entityData != null) {
                return entityData;
            }
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                entityData = this.mgmtDataMap.get(entityID);
                if (entityData != null) {
                    return entityData;
                }
                entityData = new EntityManagementData(entityID);
                this.mgmtDataMap.put(entityID, entityData);
                return entityData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagementData(@Nonnull String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                this.mgmtDataMap.remove(entityID);
            }
        }
    }
}

