/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class DecimalMaxValidatorForNumber
implements ConstraintValidator<DecimalMax, Number> {
    private static final Log log = LoggerFactory.make();
    private BigDecimal maxValue;
    private boolean inclusive;

    public void initialize(DecimalMax maxValue) {
        try {
            this.maxValue = new BigDecimal(maxValue.value());
        }
        catch (NumberFormatException nfe) {
            throw log.getInvalidBigDecimalFormatException(maxValue.value(), nfe);
        }
        this.inclusive = maxValue.inclusive();
    }

    public boolean isValid(Number value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof Double) {
            if ((Double)value == Double.NEGATIVE_INFINITY) {
                return true;
            }
            if (Double.isNaN((Double)value) || (Double)value == Double.POSITIVE_INFINITY) {
                return false;
            }
        } else if (value instanceof Float) {
            if (((Float)value).floatValue() == Float.NEGATIVE_INFINITY) {
                return true;
            }
            if (Float.isNaN(((Float)value).floatValue()) || ((Float)value).floatValue() == Float.POSITIVE_INFINITY) {
                return false;
            }
        }
        int comparisonResult = value instanceof BigDecimal ? ((BigDecimal)value).compareTo(this.maxValue) : (value instanceof BigInteger ? new BigDecimal((BigInteger)value).compareTo(this.maxValue) : (value instanceof Long ? BigDecimal.valueOf(value.longValue()).compareTo(this.maxValue) : BigDecimal.valueOf(value.doubleValue()).compareTo(this.maxValue)));
        return this.inclusive ? comparisonResult <= 0 : comparisonResult < 0;
    }
}

