/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.Map;
import org.infinispan.commons.marshall.NotSerializableException;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.infinispan.session.MutableDetector;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.session.SessionAttributes;

public class CoarseSessionAttributes
extends CoarseImmutableSessionAttributes
implements SessionAttributes {
    private final Map<String, Object> attributes;
    private final Mutator mutator;
    private final MarshallingContext context;
    private final boolean requireMarshallable;

    public CoarseSessionAttributes(Map<String, Object> attributes, Mutator mutator, MarshallingContext context, boolean requireMarshallable) {
        super(attributes);
        this.attributes = attributes;
        this.mutator = mutator;
        this.context = context;
        this.requireMarshallable = requireMarshallable;
    }

    public Object removeAttribute(String name) {
        Object value = this.attributes.remove(name);
        this.mutator.mutate();
        return value;
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        if (this.requireMarshallable && !this.context.isMarshallable(value)) {
            throw new IllegalArgumentException((Throwable)new NotSerializableException(value.getClass().getName()));
        }
        Object old = this.attributes.put(name, value);
        this.mutator.mutate();
        return old;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (MutableDetector.isMutable(value)) {
            this.mutator.mutate();
        }
        return value;
    }
}

