/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

class ModelControllerLock {
    private final Sync sync = new Sync();

    ModelControllerLock() {
    }

    void lock(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquire(permit);
    }

    boolean lock(Integer permit, long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = false;
        try {
            result = this.lockInterruptibly(permit, timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    void lockInterruptibly(Integer permit) throws InterruptedException {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireInterruptibly(permit);
    }

    boolean lockInterruptibly(Integer permit, long timeout, TimeUnit unit) throws InterruptedException {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        return this.sync.tryAcquireNanos(permit, unit.toNanos(timeout));
    }

    void unlock(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.release(permit);
    }

    boolean detectDeadlockAndGetLock(int permit) {
        return this.sync.tryAcquire(permit);
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;
        private final AtomicReference<Object> permitHolder = new AtomicReference<Object>(null);

        private Sync() {
        }

        @Override
        protected synchronized boolean tryAcquire(int permit) {
            if (this.compareAndSetState(0, 1)) {
                this.permitHolder.set(permit);
                return true;
            }
            if (this.permitHolder.get().equals(permit)) {
                int next;
                int current;
                do {
                    if ((next = (current = this.getState()) + 1) >= 0) continue;
                    throw new Error("Maximum lock count exceeded");
                } while (!this.compareAndSetState(current, next));
                return true;
            }
            return false;
        }

        @Override
        protected synchronized boolean tryRelease(int permit) {
            Object value = this.permitHolder.get();
            if (value == null) {
                throw new IllegalStateException();
            }
            if (value.equals(permit)) {
                int next;
                int current;
                do {
                    if ((next = (current = this.getState()) - 1) >= 0) continue;
                    throw new IllegalStateException();
                } while (!this.compareAndSetState(current, next));
                if (next == 0) {
                    this.permitHolder.compareAndSet(value, null);
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

