/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformRule;

class ModelMatcher {
    ModelMatcher() {
    }

    public static List<TransformRule> getRules(ImmutableManagementResourceRegistration current, ImmutableManagementResourceRegistration target) {
        Model currentAttributes = ModelMatcher.readModel(current, PathAddress.EMPTY_ADDRESS);
        Model targetAttributes = ModelMatcher.readModel(target, PathAddress.EMPTY_ADDRESS);
        if (targetAttributes.isSame(currentAttributes)) {
            return targetAttributes.toRules();
        }
        return targetAttributes.getMatchedRules(currentAttributes);
    }

    public static Model readModel(ImmutableManagementResourceRegistration def, PathAddress address) {
        Model res = new Model(address);
        Set<String> attributesList = def.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        for (String name : attributesList) {
            res.addAttribute(name);
        }
        for (PathElement element : def.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ImmutableManagementResourceRegistration child = def.getSubModel(PathAddress.pathAddress(element));
            if (child == null) continue;
            res.addChild(ModelMatcher.readModel(child, address.append(element)));
        }
        return res;
    }

    static class Model {
        private PathAddress address;
        private List<String> attributes = new LinkedList<String>();
        private List<Model> children = new LinkedList<Model>();

        Model(PathAddress address) {
            this.address = address;
        }

        protected void addAttribute(String name) {
            this.attributes.add(name);
        }

        protected void addChild(Model child) {
            this.children.add(child);
        }

        public boolean isSame(Model model) {
            if (this == model) {
                return true;
            }
            if (this.address != null ? !this.address.equals(model.address) : model.address != null) {
                return false;
            }
            if (this.attributes != null ? !this.attributes.equals(model.attributes) : model.attributes != null) {
                return false;
            }
            return !(this.children != null ? !this.children.equals(model.children) : model.children != null);
        }

        public int getAttributeCount() {
            int i = this.attributes.size();
            List<Model> c = this.children;
            while (c != null && !c.isEmpty()) {
                for (Model child : c) {
                    i += child.attributes.size();
                    c = child.children;
                }
            }
            return i;
        }

        public List<TransformRule> toRules() {
            LinkedList<TransformRule> rules = new LinkedList<TransformRule>();
            for (String attribute : this.attributes) {
                rules.add(new TransformRule(this.address, this.address, attribute, attribute));
            }
            List<Model> c = this.children;
            while (c != null && !c.isEmpty()) {
                for (Model child : c) {
                    for (String attribute : child.attributes) {
                        rules.add(new TransformRule(child.address, child.address, attribute, attribute));
                    }
                    c = child.children;
                }
            }
            return rules;
        }

        public List<TransformRule> getMatchedRules(Model other) {
            LinkedList<TransformRule> rules = new LinkedList<TransformRule>();
            for (String attribute : this.attributes) {
                TransformRule r = this.matchAttribute(attribute, other);
                if (r == null) continue;
                r.setSourceAddress(this.address);
                rules.add(r);
            }
            List<Model> c = this.children;
            while (c != null && !c.isEmpty()) {
                for (Model child : c) {
                    for (String attribute : child.attributes) {
                        TransformRule r = this.matchAttribute(attribute, child);
                        if (r == null) continue;
                        r.setSourceAddress(child.address);
                        rules.add(r);
                    }
                    c = child.children;
                }
            }
            return rules;
        }

        private TransformRule matchAttribute(String source, Model other) {
            for (String attribute : other.attributes) {
                if (!attribute.equals(source)) continue;
                return new TransformRule(null, other.address, source, attribute);
            }
            List<Model> c = other.children;
            while (c != null && !c.isEmpty()) {
                for (Model child : c) {
                    for (String attribute : child.attributes) {
                        if (!attribute.equals(source)) continue;
                        return new TransformRule(null, child.address, source, attribute);
                    }
                    c = child.children;
                }
            }
            return null;
        }
    }
}

