/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orb;

import com.sun.corba.se.spi.orb.ParserData;
import com.sun.corba.se.spi.orb.ParserImplBase;
import com.sun.corba.se.spi.orb.PropertyParser;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ParserImplTableBase
extends ParserImplBase {
    private final ParserData[] entries;

    public ParserImplTableBase(ParserData[] entries) {
        this.entries = entries;
        this.setDefaultValues();
    }

    @Override
    protected PropertyParser makeParser() {
        PropertyParser result = new PropertyParser();
        for (int ctr = 0; ctr < this.entries.length; ++ctr) {
            ParserData entry = this.entries[ctr];
            entry.addToParser(result);
        }
        return result;
    }

    protected void setDefaultValues() {
        FieldMap map = new FieldMap(this.entries, true);
        this.setFields(map);
    }

    public void setTestValues() {
        FieldMap map = new FieldMap(this.entries, false);
        this.setFields(map);
    }

    private static class FieldMap
    extends AbstractMap {
        private final ParserData[] entries;
        private final boolean useDefault;

        public FieldMap(ParserData[] entries, boolean useDefault) {
            this.entries = entries;
            this.useDefault = useDefault;
        }

        @Override
        public Set entrySet() {
            return new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new Iterator(){
                        int ctr = 0;

                        @Override
                        public boolean hasNext() {
                            return this.ctr < FieldMap.this.entries.length;
                        }

                        public Object next() {
                            ParserData pd = FieldMap.this.entries[this.ctr++];
                            MapEntry result = new MapEntry(pd.getFieldName());
                            if (FieldMap.this.useDefault) {
                                result.setValue(pd.getDefaultValue());
                            } else {
                                result.setValue(pd.getTestValue());
                            }
                            return result;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return FieldMap.this.entries.length;
                }
            };
        }
    }

    private static final class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public MapEntry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof MapEntry)) {
                return false;
            }
            MapEntry other = (MapEntry)obj;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

