/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.metadata.parser.jbossweb.ReplicationConfigParser;
import org.jboss.metadata.parser.servlet.SessionConfigMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.session.SharedSessionManagerConfig;

public class SharedSessionConfigParser_1_0
implements JBossAllXMLParser<SharedSessionManagerConfig> {
    public static final String NAMESPACE_1_0 = "urn:jboss:shared-session-config:1.0";
    public static final QName ROOT_ELEMENT = new QName("urn:jboss:shared-session-config:1.0", "shared-session-config");
    public static final SharedSessionConfigParser_1_0 INSTANCE = new SharedSessionConfigParser_1_0();

    public SharedSessionManagerConfig parse(XMLExtendedStreamReader reader, DeploymentUnit deploymentUnit) throws XMLStreamException {
        if (deploymentUnit.getParent() != null) {
            UndertowLogger.ROOT_LOGGER.sharedSessionConfigNotInRootDeployment(deploymentUnit.getName());
            return null;
        }
        SharedSessionManagerConfig result = new SharedSessionManagerConfig();
        PropertyReplacer propertyReplacer = JBossDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)deploymentUnit);
        this.readElement(reader, result, propertyReplacer);
        return result;
    }

    private SharedSessionConfigParser_1_0() {
    }

    public void readElement(XMLExtendedStreamReader reader, SharedSessionManagerConfig result, PropertyReplacer propertyReplacer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        if (count != 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case MAX_ACTIVE_SESSIONS: {
                            String value = SharedSessionConfigParser_1_0.getElementText((XMLStreamReader)reader, propertyReplacer);
                            result.setMaxActiveSessions(Integer.parseInt(value));
                            continue block9;
                        }
                        case REPLICATION_CONFIG: {
                            result.setReplicationConfig(ReplicationConfigParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                            continue block9;
                        }
                        case SESSION_CONFIG: {
                            result.setSessionConfig(SessionConfigMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                            continue block9;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        throw SharedSessionConfigParser_1_0.endOfDocument(reader.getLocation());
    }

    private static String getElementText(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return propertyReplacer.replaceProperties(reader.getElementText());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return ServerLogger.ROOT_LOGGER.unexpectedEndOfDocument(location);
    }

    static enum Attribute {
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributes = attributesMap;
        }
    }

    static enum Version {
        UNDERTOW_SHARED_1_0,
        UNKNOWN;

    }

    static enum Element {
        MAX_ACTIVE_SESSIONS,
        REPLICATION_CONFIG,
        SESSION_CONFIG,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(SharedSessionConfigParser_1_0.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(SharedSessionConfigParser_1_0.NAMESPACE_1_0, "max-active-sessions"), MAX_ACTIVE_SESSIONS);
            elementsMap.put(new QName(SharedSessionConfigParser_1_0.NAMESPACE_1_0, "replication-config"), REPLICATION_CONFIG);
            elementsMap.put(new QName(SharedSessionConfigParser_1_0.NAMESPACE_1_0, "session-config"), SESSION_CONFIG);
            elements = elementsMap;
        }
    }
}

