/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.Constants;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.client.ejb.EJBClientHandler;
import org.jboss.naming.remote.protocol.Versions;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.AbstractIoFuture;
import org.xnio.IoFuture;
import org.xnio.IoUtils;

class RemoteContextFactory {
    private static final Logger log = Logger.getLogger(RemoteContextFactory.class);

    RemoteContextFactory() {
    }

    static RemoteNamingStore createVersionedStore(Channel channel) throws IOException {
        return RemoteContextFactory.createVersionedStore(channel, null);
    }

    static RemoteNamingStore createVersionedStore(Channel channel, EJBClientHandler ejbClientHandler) throws IOException {
        IoFuture<byte[]> futureHeader = ClientVersionReceiver.getVersions(channel);
        IoFuture.Status result = futureHeader.await(5L, TimeUnit.SECONDS);
        switch (result) {
            case DONE: {
                break;
            }
            case FAILED: {
                throw futureHeader.getException();
            }
            default: {
                throw new IOException("Timeout out waiting for header, status=" + result.toString());
            }
        }
        byte highest = 0;
        for (byte current : futureHeader.get()) {
            if (current <= highest) continue;
            highest = current;
        }
        RemoteNamingStore store = Versions.getRemoteNamingStore(highest, channel, ejbClientHandler);
        return store;
    }

    private static class VersionsIoFuture
    extends AbstractIoFuture<byte[]> {
        private VersionsIoFuture() {
        }

        @Override
        protected boolean setResult(byte[] result) {
            return super.setResult(result);
        }

        @Override
        protected boolean setException(IOException exception) {
            return super.setException(exception);
        }
    }

    private static class ClientVersionReceiver
    implements Channel.Receiver {
        private final VersionsIoFuture future;

        private ClientVersionReceiver(VersionsIoFuture future) {
            this.future = future;
        }

        public static IoFuture<byte[]> getVersions(Channel channel) {
            VersionsIoFuture future = new VersionsIoFuture();
            channel.receiveMessage(new ClientVersionReceiver(future));
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dis = new DataInputStream(messageInputStream);
            try {
                int expectedHeaderLength = Constants.NAMING.length;
                byte[] header = new byte[expectedHeaderLength];
                int read = dis.read(header);
                if (read < expectedHeaderLength || !Arrays.equals(header, Constants.NAMING)) {
                    throw new IOException("Invalid leading bytes in header.");
                }
                int versionCount = dis.read();
                byte[] versions = new byte[versionCount];
                read = dis.read(versions);
                if (read < versionCount) {
                    throw new IOException("Did not read all versions.");
                }
                this.future.setResult(versions);
            }
            catch (IOException e) {
                log.error((Object)"Unable to negotiate connection.", e);
                this.future.setException(e);
            }
            finally {
                IoUtils.safeClose((Closeable)dis);
            }
        }

        @Override
        public void handleError(Channel channel, IOException e) {
            log.error((Object)"Error on channel", e);
            this.future.setException(e);
        }

        @Override
        public void handleEnd(Channel channel) {
            log.error("Channel ended.");
            this.future.setException(new IOException("Channel ended"));
        }
    }
}

