/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import org.infinispan.commons.equivalence.Equivalence;

public class StripedHashFunction<T> {
    private final Equivalence<T> equivalence;
    private final int lockSegmentMask;
    private final int lockSegmentShift;
    private final int numSegments;

    public StripedHashFunction(Equivalence<T> equivalence, int concurrencyLevel) {
        int tmpNumSegments;
        this.equivalence = equivalence;
        int tempLockSegShift = 0;
        for (tmpNumSegments = 1; tmpNumSegments < concurrencyLevel; tmpNumSegments <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = tmpNumSegments - 1;
        this.numSegments = tmpNumSegments;
    }

    private static int hash(int hashCode) {
        int h = hashCode;
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public final int getNumSegments() {
        return this.numSegments;
    }

    public final int hashToSegment(T object) {
        return StripedHashFunction.hash(this.equivalence.hashCode(object)) >>> this.lockSegmentShift & this.lockSegmentMask;
    }
}

