/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.xsite.BackupSender;

public class XSiteAdminCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 32;
    private String siteName;
    private Integer afterFailures;
    private Long minTimeToWait;
    private AdminOperation adminOperation;
    private BackupSender backupSender;

    public XSiteAdminCommand() {
        super(null);
    }

    public XSiteAdminCommand(String cacheName) {
        super(cacheName);
    }

    public XSiteAdminCommand(String cacheName, String siteName, AdminOperation op, Integer afterFailures, Long minTimeToWait) {
        this(cacheName);
        this.siteName = siteName;
        this.adminOperation = op;
        this.afterFailures = afterFailures;
        this.minTimeToWait = minTimeToWait;
    }

    public void init(BackupSender backupSender) {
        this.backupSender = backupSender;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.adminOperation) {
            case SITE_STATUS: {
                if (this.backupSender.getOfflineStatus(this.siteName).isOffline()) {
                    return Status.OFFLINE;
                }
                return Status.ONLINE;
            }
            case STATUS: {
                return this.backupSender.status();
            }
            case TAKE_OFFLINE: {
                return this.backupSender.takeSiteOffline(this.siteName);
            }
            case BRING_ONLINE: {
                return this.backupSender.bringSiteOnline(this.siteName);
            }
            case AMEND_TAKE_OFFLINE: {
                this.backupSender.getOfflineStatus(this.siteName).amend(this.afterFailures, this.minTimeToWait);
                return null;
            }
        }
        throw new IllegalStateException("Unhandled admin operation " + (Object)((Object)this.adminOperation));
    }

    @Override
    public byte getCommandId() {
        return 32;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.siteName, this.afterFailures, this.minTimeToWait, this.adminOperation};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        this.siteName = (String)parameters[0];
        this.afterFailures = (Integer)parameters[1];
        this.minTimeToWait = (Long)parameters[2];
        this.adminOperation = (AdminOperation)((Object)parameters[3]);
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "XSiteAdminCommand{siteName='" + this.siteName + '\'' + ", afterFailures=" + this.afterFailures + ", minTimeToWait=" + this.minTimeToWait + ", adminOperation=" + (Object)((Object)this.adminOperation) + ", backupSender=" + this.backupSender + '}';
    }

    public static enum Status {
        OFFLINE,
        ONLINE;

    }

    public static enum AdminOperation {
        SITE_STATUS,
        STATUS,
        TAKE_OFFLINE,
        BRING_ONLINE,
        AMEND_TAKE_OFFLINE;

    }
}

