/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;

public class AsynchronousServiceBuilder<T>
implements Builder<T>,
Service<T> {
    private final InjectedValue<ExecutorService> executor = new InjectedValue();
    final Service<T> service;
    private final ServiceName name;
    private volatile boolean startAsynchronously = true;
    private volatile boolean stopAsynchronously = true;

    public AsynchronousServiceBuilder(ServiceName name, Service<T> service) {
        this.name = name;
        this.service = service;
    }

    @Override
    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public ServiceBuilder<T> build(ServiceTarget target) {
        return target.addService(this.name, (Service)this).addDependency(ServiceName.JBOSS.append(new String[]{"as", "server-executor"}), ExecutorService.class, this.executor).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public AsynchronousServiceBuilder<T> startSynchronously() {
        this.startAsynchronously = false;
        return this;
    }

    public AsynchronousServiceBuilder<T> stopSynchronously() {
        this.stopAsynchronously = false;
        return this;
    }

    public T getValue() {
        return (T)this.service.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        if (this.startAsynchronously) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        AsynchronousServiceBuilder.this.service.start(context);
                        context.complete();
                    }
                    catch (StartException e) {
                        context.failed(e);
                    }
                    catch (Throwable e) {
                        context.failed(new StartException(e));
                    }
                }
            };
            try {
                ((ExecutorService)this.executor.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        } else {
            this.service.start(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(final StopContext context) {
        if (this.stopAsynchronously) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        AsynchronousServiceBuilder.this.service.stop(context);
                    }
                    finally {
                        context.complete();
                    }
                }
            };
            try {
                ((ExecutorService)this.executor.getValue()).execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
            finally {
                context.asynchronous();
            }
        } else {
            this.service.stop(context);
        }
    }
}

