/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import javax.xml.namespace.QName;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.binding.soap.Soap12;

public final class SoapEncodingUtil {
    private static final String SOAP_ENCODING_NS_1_2 = Soap12.getInstance().getSoapEncodingStyle();
    private static final QName SOAP_ENCODING_ID_1_2 = new QName(SOAP_ENCODING_NS_1_2, "id");
    private static final QName SOAP_ENCODING_ID_1_1 = new QName("id");
    private static final QName SOAP_ENCODING_REF_1_2 = new QName(SOAP_ENCODING_NS_1_2, "ref");
    private static final QName SOAP_ENCODING_REF_1_1 = new QName("href");

    private SoapEncodingUtil() {
    }

    public static String readId(MessageReader reader) {
        String id = SoapEncodingUtil.readAttributeValue(reader, SOAP_ENCODING_ID_1_2);
        if (id == null) {
            id = SoapEncodingUtil.readAttributeValue(reader, SOAP_ENCODING_ID_1_1);
        }
        return id;
    }

    public static void writeId(MessageWriter writer, String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        SoapEncodingUtil.writeAttribute(writer, SOAP_ENCODING_ID_1_1, id);
    }

    public static String readRef(MessageReader reader) {
        String ref = SoapEncodingUtil.readAttributeValue(reader, SOAP_ENCODING_REF_1_2);
        if (ref == null) {
            ref = SoapEncodingUtil.readAttributeValue(reader, SOAP_ENCODING_REF_1_1);
        }
        return ref;
    }

    public static void writeRef(MessageWriter writer, String refId) {
        if (refId == null) {
            throw new NullPointerException("refId is null");
        }
        SoapEncodingUtil.writeAttribute(writer, SOAP_ENCODING_REF_1_1, refId);
    }

    public static String readAttributeValue(MessageReader reader, QName name) {
        String value;
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        MessageReader attributeReader = reader.getAttributeReader(name);
        if (attributeReader != null && (value = attributeReader.getValue()) != null) {
            return value;
        }
        return null;
    }

    public static void writeAttribute(MessageWriter writer, QName name, String value) {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        MessageWriter attributeWriter = writer.getAttributeWriter(name);
        attributeWriter.writeValue(value);
        attributeWriter.close();
    }
}

