/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.ThreadMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanCpuTimeHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanDumpAllThreadsHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanFindDeadlockedThreadsHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanFindMonitorDeadlockedThreadsHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanReadResourceHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanResetPeakThreadCountHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanThreadInfoHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanThreadInfosHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanUserTimeHandler;
import org.jboss.dmr.ModelType;

class ThreadResourceDefinition
extends SimpleResourceDefinition {
    static AttributeDefinition CURRENT_THREAD_CPU_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"current-thread-cpu-time", (ModelType)ModelType.LONG, (boolean)false).setMeasurementUnit(MeasurementUnit.NANOSECONDS)).setStorageRuntime()).build();
    static AttributeDefinition CURRENT_THREAD_USER_TIME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"current-thread-user-time", (ModelType)ModelType.LONG, (boolean)false).setMeasurementUnit(MeasurementUnit.NANOSECONDS)).setStorageRuntime()).build();
    static AttributeDefinition ALL_THREAD_IDS = ((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("all-thread-ids", ModelType.LONG).setStorageRuntime()).build();
    static AttributeDefinition THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-count", (ModelType)ModelType.INT, (boolean)false).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.NONE)).build();
    static AttributeDefinition PEAK_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"peak-thread-count", (ModelType)ModelType.INT, (boolean)false).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.NONE)).build();
    static AttributeDefinition TOTAL_STARTED_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"total-started-thread-count", (ModelType)ModelType.LONG, (boolean)false).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.NONE)).build();
    static AttributeDefinition DAEMON_THREAD_COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"daemon-thread-count", (ModelType)ModelType.INT, (boolean)false).setStorageRuntime()).setMeasurementUnit(MeasurementUnit.NONE)).build();
    static AttributeDefinition THREAD_CONTENTION_MONITORING_SUPPORTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-contention-monitoring-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    static AttributeDefinition THREAD_CONTENTION_MONITORING_ENABLED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-contention-monitoring-enabled", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    static AttributeDefinition THREAD_CPU_TIME_SUPPORTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-cpu-time-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    static AttributeDefinition CURRENT_THREAD_CPU_TIME_SUPPORTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"current-thread-cpu-time-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    static AttributeDefinition THREAD_CPU_TIME_ENABLED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-cpu-time-enabled", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    static AttributeDefinition OBJECT_MONITOR_USAGE_SUPPORTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"object-monitor-usage-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    static AttributeDefinition SYNCHRONIZER_USAGE_SUPPORTED = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"synchronizer-usage-supported", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).build();
    static final List<AttributeDefinition> METRICS = Arrays.asList(THREAD_COUNT, PEAK_THREAD_COUNT, TOTAL_STARTED_THREAD_COUNT, DAEMON_THREAD_COUNT, CURRENT_THREAD_CPU_TIME, CURRENT_THREAD_USER_TIME);
    static final List<AttributeDefinition> READ_ATTRIBUTES = Arrays.asList(ALL_THREAD_IDS, THREAD_CONTENTION_MONITORING_SUPPORTED, THREAD_CPU_TIME_SUPPORTED, CURRENT_THREAD_CPU_TIME_SUPPORTED, OBJECT_MONITOR_USAGE_SUPPORTED, SYNCHRONIZER_USAGE_SUPPORTED);
    static final List<AttributeDefinition> READ_WRITE_ATTRIBUTES = Arrays.asList(THREAD_CONTENTION_MONITORING_ENABLED, THREAD_CPU_TIME_ENABLED);
    static final List<String> THREADING_READ_ATTRIBUTES = Arrays.asList(ALL_THREAD_IDS.getName(), THREAD_CONTENTION_MONITORING_SUPPORTED.getName(), THREAD_CPU_TIME_SUPPORTED.getName(), CURRENT_THREAD_CPU_TIME_SUPPORTED.getName(), OBJECT_MONITOR_USAGE_SUPPORTED.getName(), SYNCHRONIZER_USAGE_SUPPORTED.getName());
    static final List<String> THREADING_METRICS = Arrays.asList(THREAD_COUNT.getName(), PEAK_THREAD_COUNT.getName(), TOTAL_STARTED_THREAD_COUNT.getName(), DAEMON_THREAD_COUNT.getName(), CURRENT_THREAD_CPU_TIME.getName(), CURRENT_THREAD_USER_TIME.getName());
    static final List<String> THREADING_READ_WRITE_ATTRIBUTES = Arrays.asList(THREAD_CONTENTION_MONITORING_ENABLED.getName(), THREAD_CPU_TIME_ENABLED.getName());
    static final ThreadResourceDefinition INSTANCE = new ThreadResourceDefinition();
    static EnumSet<OperationEntry.Flag> READ_ONLY_RUNTIME_ONLY_FLAG = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY, OperationEntry.Flag.READ_ONLY);

    private ThreadResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PlatformMBeanConstants.THREADING_PATH, (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        super.registerAttributes(registration);
        registration.registerReadOnlyAttribute((AttributeDefinition)PlatformMBeanConstants.OBJECT_NAME, (OperationStepHandler)ThreadMXBeanAttributeHandler.INSTANCE);
        for (AttributeDefinition attribute : READ_WRITE_ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, (OperationStepHandler)ThreadMXBeanAttributeHandler.INSTANCE, (OperationStepHandler)ThreadMXBeanAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition attribute : READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)ThreadMXBeanAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition attribute : METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)ThreadMXBeanAttributeHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration threads) {
        super.registerOperations(threads);
        threads.registerOperationHandler(ReadResourceHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanReadResourceHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanResetPeakThreadCountHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanResetPeakThreadCountHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanFindDeadlockedThreadsHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanFindDeadlockedThreadsHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanFindMonitorDeadlockedThreadsHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanFindMonitorDeadlockedThreadsHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanThreadInfoHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanThreadInfoHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanThreadInfosHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanThreadInfosHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanCpuTimeHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanCpuTimeHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanUserTimeHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanUserTimeHandler.INSTANCE);
        threads.registerOperationHandler(ThreadMXBeanDumpAllThreadsHandler.DEFINITION, (OperationStepHandler)ThreadMXBeanDumpAllThreadsHandler.INSTANCE);
    }
}

