/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.ResourceProvider;
import org.jboss.dmr.ModelNode;

public abstract class AbstractModelResource
extends ResourceProvider.ResourceProviderRegistry
implements Resource {
    private final Map<String, ResourceProvider> children = new LinkedHashMap<String, ResourceProvider>();
    private final boolean runtimeOnly;
    private final Set<String> orderedChildTypes;

    protected AbstractModelResource() {
        this(false);
    }

    protected AbstractModelResource(boolean runtimeOnly) {
        this(runtimeOnly, (Set<String>)null);
    }

    protected AbstractModelResource(boolean runtimeOnly, String ... orderedChildTypes) {
        this(runtimeOnly, AbstractModelResource.arrayToSet(orderedChildTypes));
    }

    protected AbstractModelResource(boolean runtimeOnly, Set<String> orderedChildTypes) {
        this.runtimeOnly = runtimeOnly;
        this.orderedChildTypes = orderedChildTypes == null || orderedChildTypes.size() == 0 ? Collections.emptySet() : orderedChildTypes;
    }

    private static Set<String> arrayToSet(String[] array) {
        Set<String> set;
        if (array.length == 0) {
            set = Collections.emptySet();
        } else {
            set = new HashSet();
            for (String type : array) {
                set.add(type);
            }
        }
        return set;
    }

    @Override
    public Resource getChild(PathElement address) {
        ResourceProvider provider = this.getProvider(address.getKey());
        if (provider == null) {
            return null;
        }
        return provider.get(address.getValue());
    }

    @Override
    public boolean hasChild(PathElement address) {
        ResourceProvider provider = this.getProvider(address.getKey());
        if (provider == null) {
            return false;
        }
        if (address.isWildcard()) {
            return provider.hasChildren();
        }
        return provider.has(address.getValue());
    }

    @Override
    public Resource requireChild(PathElement address) {
        Resource resource = this.getChild(address);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(address);
        }
        return resource;
    }

    @Override
    public boolean hasChildren(String childType) {
        ResourceProvider provider = this.getProvider(childType);
        return provider != null && provider.hasChildren();
    }

    @Override
    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate(this, address);
    }

    @Override
    public Set<String> getChildrenNames(String childType) {
        ResourceProvider provider = this.getProvider(childType);
        if (provider == null) {
            return Collections.emptySet();
        }
        return provider.children();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getChildTypes() {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            return new LinkedHashSet<String>(this.children.keySet());
        }
    }

    @Override
    public Set<Resource.ResourceEntry> getChildren(final String childType) {
        ResourceProvider provider = this.getProvider(childType);
        if (provider == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Resource.ResourceEntry> children = new LinkedHashSet<Resource.ResourceEntry>();
        for (final String name : provider.children()) {
            Resource resource = provider.get(name);
            children.add(new DelegateResource(resource){

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public PathElement getPathElement() {
                    return PathElement.pathElement(childType, name);
                }
            });
        }
        return children;
    }

    @Override
    public void registerChild(PathElement address, Resource resource) {
        if (address.isMultiTarget()) {
            throw new IllegalArgumentException();
        }
        this.getOrCreateProvider(address.getKey()).register(address.getValue(), resource);
    }

    @Override
    public void registerChild(PathElement address, int index, Resource resource) {
        if (address.isMultiTarget()) {
            throw new IllegalArgumentException();
        }
        if (index >= 0 && !this.orderedChildTypes.contains(address.getKey())) {
            throw ControllerLogger.ROOT_LOGGER.indexedChildResourceRegistrationNotAvailable(address);
        }
        this.getOrCreateProvider(address.getKey()).register(address.getValue(), index, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource removeChild(PathElement address) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            ResourceProvider provider = this.getProvider(address.getKey());
            if (provider == null) {
                return null;
            }
            Resource removed = provider.remove(address.getValue());
            if (provider instanceof DefaultResourceProvider && !provider.hasChildren()) {
                this.children.remove(address.getKey());
            }
            return removed;
        }
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public boolean isRuntime() {
        return this.runtimeOnly;
    }

    @Override
    public Set<String> getOrderedChildTypes() {
        return this.orderedChildTypes.size() == 0 ? this.orderedChildTypes : Collections.unmodifiableSet(this.orderedChildTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerResourceProvider(String type, ResourceProvider provider) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            if (this.children.containsKey(type)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateResourceType(type);
            }
            this.children.put(type, provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResourceProvider getProvider(String type) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            return this.children.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceProvider getOrCreateProvider(String type) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            ResourceProvider provider = this.children.get(type);
            if (provider != null) {
                return provider;
            }
            DefaultResourceProvider newProvider = new DefaultResourceProvider();
            this.children.put(type, newProvider);
            return newProvider;
        }
    }

    @Override
    public abstract Resource clone();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cloneProviders(AbstractModelResource clone) {
        Map<String, ResourceProvider> map = this.children;
        synchronized (map) {
            for (Map.Entry<String, ResourceProvider> entry : this.children.entrySet()) {
                clone.registerResourceProvider(entry.getKey(), entry.getValue().clone());
            }
        }
    }

    static abstract class DelegateResource
    implements Resource.ResourceEntry {
        final Resource delegate;

        protected DelegateResource(Resource delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException();
            }
            this.delegate = delegate;
        }

        @Override
        public Resource getChild(PathElement element) {
            return this.delegate.getChild(element);
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            return this.delegate.getChildren(childType);
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            return this.delegate.getChildrenNames(childType);
        }

        @Override
        public Set<String> getChildTypes() {
            return this.delegate.getChildTypes();
        }

        @Override
        public ModelNode getModel() {
            return this.delegate.getModel();
        }

        @Override
        public boolean hasChild(PathElement element) {
            return this.delegate.hasChild(element);
        }

        @Override
        public boolean hasChildren(String childType) {
            return this.delegate.hasChildren(childType);
        }

        @Override
        public boolean isModelDefined() {
            return this.delegate.isModelDefined();
        }

        @Override
        public Resource navigate(PathAddress address) {
            return this.delegate.navigate(address);
        }

        @Override
        public void registerChild(PathElement address, Resource resource) {
            this.delegate.registerChild(address, resource);
        }

        @Override
        public void registerChild(PathElement address, int index, Resource resource) {
            this.delegate.registerChild(address, index, resource);
        }

        @Override
        public Resource removeChild(PathElement address) {
            return this.delegate.removeChild(address);
        }

        @Override
        public Resource requireChild(PathElement element) {
            return this.delegate.requireChild(element);
        }

        @Override
        public void writeModel(ModelNode newModel) {
            this.delegate.writeModel(newModel);
        }

        @Override
        public boolean isRuntime() {
            return this.delegate.isRuntime();
        }

        @Override
        public boolean isProxy() {
            return this.delegate.isProxy();
        }

        @Override
        public Set<String> getOrderedChildTypes() {
            return this.delegate.getOrderedChildTypes();
        }

        @Override
        public Resource clone() {
            return this.delegate.clone();
        }
    }

    private class DefaultResourceProvider
    implements ResourceProvider {
        private final Map<String, Resource> children = new LinkedHashMap<String, Resource>();

        protected DefaultResourceProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> children() {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return new LinkedHashSet<String>(this.children.keySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean has(String name) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return this.children.get(name) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resource get(String name) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return this.children.get(name);
            }
        }

        @Override
        public boolean hasChildren() {
            return !this.children().isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void register(String name, Resource resource) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                if (this.children.containsKey(name)) {
                    throw ControllerLogger.ROOT_LOGGER.duplicateResource(name);
                }
                this.children.put(name, resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void register(String name, int index, Resource resource) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                if (this.children.containsKey(name)) {
                    throw ControllerLogger.ROOT_LOGGER.duplicateResource(name);
                }
                if (index < 0 || index >= this.children.size()) {
                    this.children.put(name, resource);
                } else {
                    ArrayList<Map.Entry<String, Resource>> list = new ArrayList<Map.Entry<String, Resource>>(this.children.entrySet());
                    this.children.clear();
                    boolean done = false;
                    int i = 0;
                    for (Map.Entry entry : list) {
                        if (!done) {
                            if (i++ < index) {
                                this.children.put((String)entry.getKey(), (Resource)entry.getValue());
                                continue;
                            }
                            this.children.put(name, resource);
                            this.children.put((String)entry.getKey(), (Resource)entry.getValue());
                            done = true;
                            continue;
                        }
                        this.children.put((String)entry.getKey(), (Resource)entry.getValue());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resource remove(String name) {
            Map<String, Resource> map = this.children;
            synchronized (map) {
                return this.children.remove(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceProvider clone() {
            DefaultResourceProvider provider = new DefaultResourceProvider();
            Map<String, Resource> map = this.children;
            synchronized (map) {
                for (Map.Entry<String, Resource> entry : this.children.entrySet()) {
                    provider.register(entry.getKey(), entry.getValue().clone());
                }
            }
            return provider;
        }
    }
}

