/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.literal.AnyLiteral;

public final class EventMetadataImpl
implements EventMetadata {
    private final Type type;
    private final InjectionPoint injectionPoint;
    private final Set<Annotation> qualifiers;
    private final Annotation[] qualifierArray;

    public EventMetadataImpl(Type type, InjectionPoint injectionPoint, Set<Annotation> qualifiers) {
        this(type, injectionPoint, qualifiers, null);
    }

    public EventMetadataImpl(Type type, InjectionPoint injectionPoint, Annotation[] qualifiers) {
        this(type, injectionPoint, null, qualifiers);
    }

    private EventMetadataImpl(Type type, InjectionPoint injectionPoint, Set<Annotation> qualifiers, Annotation[] qualifierArray) {
        this.type = type;
        this.injectionPoint = injectionPoint;
        this.qualifiers = qualifiers;
        this.qualifierArray = qualifierArray;
    }

    public Set<Annotation> getQualifiers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)AnyLiteral.INSTANCE);
        if (this.qualifiers != null) {
            return builder.addAll(this.qualifiers).build();
        }
        if (this.qualifierArray != null) {
            return builder.add((Object[])this.qualifierArray).build();
        }
        throw new IllegalStateException();
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "EventMetadataImpl [type=" + this.type + ", qualifiers=" + this.qualifiers + ", injectionPoint=" + this.injectionPoint + "]";
    }
}

