/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.settings;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.helper.InterruptHook;
import org.jboss.aesh.console.settings.FileAccessPermission;
import org.jboss.aesh.console.settings.QuitHandler;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsImpl;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.util.LoggerUtil;

public class SettingsBuilder {
    SettingsImpl settings;

    public SettingsBuilder() {
        this.settings = new SettingsImpl();
    }

    public SettingsBuilder(Settings baseSettings) {
        this.settings = (SettingsImpl)baseSettings.clone();
    }

    public SettingsBuilder name(String name) {
        this.settings.setName(name);
        return this;
    }

    public SettingsBuilder mode(Mode mode) {
        this.settings.setMode(mode);
        return this;
    }

    public SettingsBuilder historyFile(File history) {
        this.settings.setHistoryFile(history);
        return this;
    }

    public SettingsBuilder historyFilePermission(FileAccessPermission fileAccessPermission) {
        this.settings.setHistoryFilePermission(fileAccessPermission);
        return this;
    }

    public SettingsBuilder historySize(int size) {
        this.settings.setHistorySize(size);
        return this;
    }

    public SettingsBuilder bellStyle(String bellStyle) {
        this.settings.setBellStyle(bellStyle);
        return this;
    }

    public SettingsBuilder ansi(boolean ansi) {
        this.settings.setAnsiConsole(ansi);
        return this;
    }

    public SettingsBuilder inputStream(InputStream inputStream) {
        this.settings.setInputStream(inputStream);
        return this;
    }

    public SettingsBuilder outputStream(PrintStream outputStream) {
        this.settings.setStdOut(outputStream);
        return this;
    }

    public SettingsBuilder outputStreamError(PrintStream error) {
        this.settings.setStdErr(error);
        return this;
    }

    public SettingsBuilder terminal(Terminal terminal) {
        this.settings.setTerminal(terminal);
        return this;
    }

    public SettingsBuilder inputrc(File inputrc) {
        this.settings.setInputrc(inputrc);
        return this;
    }

    public SettingsBuilder logging(boolean logging) {
        this.settings.setLogging(logging);
        return this;
    }

    public SettingsBuilder disableCompletion(boolean disableCompletion) {
        this.settings.setDisableCompletion(disableCompletion);
        return this;
    }

    public SettingsBuilder logfile(String logFile) {
        this.settings.setLogFile(logFile);
        return this;
    }

    public SettingsBuilder readInputrc(boolean readInputrc) {
        this.settings.setReadInputrc(readInputrc);
        return this;
    }

    public SettingsBuilder disableHistory(boolean disableHistory) {
        this.settings.setHistoryDisabled(disableHistory);
        return this;
    }

    public SettingsBuilder persistHistory(boolean persistHistory) {
        this.settings.setHistoryPersistent(persistHistory);
        return this;
    }

    public SettingsBuilder aliasFile(File aliasFile) {
        this.settings.setAliasFile(aliasFile);
        return this;
    }

    public SettingsBuilder enableAlias(boolean enableAlias) {
        this.settings.setAliasEnabled(enableAlias);
        return this;
    }

    public SettingsBuilder persistAlias(boolean persistAlias) {
        this.settings.setPersistAlias(persistAlias);
        return this;
    }

    public SettingsBuilder quitHandler(QuitHandler quitHandler) {
        this.settings.setQuitHandler(quitHandler);
        return this;
    }

    public SettingsBuilder interruptHook(InterruptHook interruptHook) {
        this.settings.setInterruptHook(interruptHook);
        return this;
    }

    public SettingsBuilder parseOperators(boolean parseOperators) {
        this.settings.enableOperatorParser(parseOperators);
        return this;
    }

    public SettingsBuilder enableMan(boolean enableMan) {
        this.settings.setManEnabled(enableMan);
        return this;
    }

    public SettingsBuilder aeshContext(AeshContext aeshContext) {
        this.settings.setAeshContext(aeshContext);
        return this;
    }

    public SettingsBuilder enableExport(boolean enableExport) {
        this.settings.setExportEnabled(enableExport);
        return this;
    }

    public SettingsBuilder exportFile(File exportFile) {
        this.settings.setExportFile(exportFile);
        return this;
    }

    public SettingsBuilder setPersistExport(boolean persistExport) {
        this.settings.setPersistExport(persistExport);
        return this;
    }

    public SettingsBuilder setExportUsesSystemEnvironment(boolean isLoad) {
        this.settings.setExportUsesSystemEnvironment(isLoad);
        return this;
    }

    public SettingsBuilder setFileResource(Resource resource) {
        this.settings.setResource(resource);
        return this;
    }

    public SettingsBuilder setExecuteAtStart(String execute) {
        this.settings.setExecuteAtStart(execute);
        return this;
    }

    public SettingsBuilder setExecuteFileAtStart(Resource executeFile) {
        this.settings.setExecuteFileAtStart(executeFile);
        return this;
    }

    public Settings create() {
        if (this.settings.isLogging()) {
            LoggerUtil.doLog();
        }
        return this.settings;
    }
}

