/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.common.model.validator.ElementMaxOccurrenceValidationStepHandler;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderResourceDefinition;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class IdentityProviderValidationStepHandler
extends ElementMaxOccurrenceValidationStepHandler {
    public IdentityProviderValidationStepHandler() {
        super(ModelElement.IDENTITY_PROVIDER, ModelElement.FEDERATION, 1);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validateSecurityDomain(context);
        this.validateOccurrence(context, operation);
        context.stepCompleted();
    }

    private void validateSecurityDomain(OperationContext context) throws OperationFailedException {
        ModelNode identityProviderNode = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
        boolean external = IdentityProviderResourceDefinition.EXTERNAL.resolveModelAttribute(context, identityProviderNode).asBoolean();
        ModelNode securityDomain = IdentityProviderResourceDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, identityProviderNode);
        if (!external && !securityDomain.isDefined()) {
            throw PicketLinkLogger.ROOT_LOGGER.requiredAttribute(ModelElement.COMMON_SECURITY_DOMAIN.getName(), ModelElement.IDENTITY_PROVIDER.getName());
        }
    }
}

