/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.ResultFilter;

public final class Configuration {
    private final FeedIdStrategy feedIdStrategy;
    private final Map<String, String> implementationConfiguration;
    private final ResultFilter resultFilter;

    public static Builder builder() {
        return new Builder();
    }

    public Configuration(FeedIdStrategy feedIdStrategy, ResultFilter resultFilter, Map<String, String> implementationConfiguration) {
        this.feedIdStrategy = feedIdStrategy;
        this.resultFilter = resultFilter;
        this.implementationConfiguration = implementationConfiguration;
    }

    public FeedIdStrategy getFeedIdStrategy() {
        return this.feedIdStrategy;
    }

    public ResultFilter getResultFilter() {
        return this.resultFilter;
    }

    public String getProperty(Property property, String defaultValue) {
        List<String> envVars;
        String value = null;
        List<String> systemProps = property.getSystemPropertyNames();
        if (systemProps != null) {
            String sp;
            Iterator<String> iterator = systemProps.iterator();
            while (iterator.hasNext() && (value = System.getProperty(sp = iterator.next())) == null) {
            }
        }
        if (value == null && (envVars = property.getEnvironmentVariableNames()) != null) {
            String ev;
            Iterator<String> iterator = envVars.iterator();
            while (iterator.hasNext() && (value = System.getenv(ev = iterator.next())) == null) {
            }
        }
        if (value == null && property.getPropertyName() != null) {
            value = this.implementationConfiguration.get(property.getPropertyName());
        }
        return value == null ? defaultValue : value;
    }

    public boolean getFlag(Property property, String defaultValue) {
        return Boolean.valueOf(this.getProperty(property, defaultValue));
    }

    public boolean getFlag(String key, String defaultValue) {
        return this.getFlag(Property.builder().withPropertyNameAndSystemProperty(key).build(), defaultValue);
    }

    public Configuration prefixedWith(String ... prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            return this;
        }
        Map<String, String> filteredConfig = this.implementationConfiguration.entrySet().stream().filter(e -> Arrays.stream(prefixes).anyMatch(p -> ((String)e.getKey()).startsWith((String)p))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new Configuration(this.feedIdStrategy, this.resultFilter, filteredConfig);
    }

    public Map<String, String> getImplementationConfiguration(Collection<? extends Property> overridableProperties) {
        return this.getOverriddenImplementationConfiguration(overridableProperties);
    }

    private <T extends Property> Map<String, String> getOverriddenImplementationConfiguration(Collection<T> overridableProperties) {
        HashMap<String, String> ret = new HashMap<String, String>();
        overridableProperties.forEach(p -> {
            String val = this.getProperty((Property)p, null);
            if (val != null) {
                ret.put(p.getPropertyName(), val);
            }
        });
        this.implementationConfiguration.forEach(ret::putIfAbsent);
        return ret;
    }

    public static interface Property {
        public String getPropertyName();

        public List<String> getSystemPropertyNames();

        default public List<String> getEnvironmentVariableNames() {
            return Collections.emptyList();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String propertyName;
            private List<String> sysProps;
            private List<String> envVars;

            public Builder withPropertyName(String propertyName) {
                this.propertyName = propertyName;
                return this;
            }

            public Builder withPropertyNameAndSystemProperty(String propertyName) {
                return this.withPropertyName(propertyName).withSystemProperties(propertyName);
            }

            public Builder withSystemProperties(String ... sysProps) {
                this.sysProps = Arrays.asList(sysProps);
                return this;
            }

            public Builder withEnvironmentVariables(String ... envVars) {
                this.envVars = Arrays.asList(envVars);
                return this;
            }

            public Property build() {
                if (this.propertyName == null) {
                    throw new IllegalStateException("A property needs to have a name defined.");
                }
                final String propertyName = this.propertyName;
                final List sysProps = this.sysProps == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(this.sysProps));
                final List envVars = this.envVars == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(this.envVars));
                return new Property(){

                    @Override
                    public String getPropertyName() {
                        return propertyName;
                    }

                    @Override
                    public List<String> getSystemPropertyNames() {
                        return sysProps;
                    }

                    @Override
                    public List<String> getEnvironmentVariableNames() {
                        return envVars;
                    }
                };
            }
        }
    }

    public static final class Builder {
        private FeedIdStrategy strategy;
        private ResultFilter resultFilter;
        private Map<String, String> configuration = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withFeedIdStrategy(FeedIdStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder withResultFilter(ResultFilter resultFilter) {
            this.resultFilter = resultFilter;
            return this;
        }

        public Builder withConfiguration(Map<String, String> configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withConfiguration(Properties properties) {
            HashMap<String, String> map = new HashMap<String, String>();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
            return this.withConfiguration(map);
        }

        public Builder addConfigurationProperty(String key, String value) {
            this.configuration.put(key, value);
            return this;
        }

        public Configuration build() {
            return new Configuration(this.strategy, this.resultFilter, this.configuration);
        }
    }
}

