/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.jgroups.Address;
import org.jgroups.View;

public final class DefaultNodeSelectorService
implements NodeSelectorService {
    private final ConcurrentHashMap<String, NodeSelectorStrategy> register = new ConcurrentHashMap(16, 0.75f, 2);
    private Address address;
    private View view;

    @Override
    public NodeSelectorStrategy getMasterNodeSelector(String indexName) {
        return this.register.get(indexName);
    }

    @Override
    public synchronized void setNodeSelectorStrategy(String indexName, NodeSelectorStrategy selector) {
        this.register.put(indexName, selector);
        if (this.address != null) {
            selector.setLocalAddress(this.address);
        }
        if (this.view != null) {
            selector.viewAccepted(this.view);
        }
    }

    @Override
    public synchronized void setLocalAddress(Address address) {
        this.address = address;
        for (NodeSelectorStrategy s : this.register.values()) {
            s.setLocalAddress(address);
        }
    }

    @Override
    public synchronized void viewAccepted(View view) {
        this.view = view;
        for (NodeSelectorStrategy s : this.register.values()) {
            s.viewAccepted(view);
        }
    }
}

