/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;

public class TestDecoder {
    private DecoderImpl decoder = new DecoderImpl();
    private EncoderImpl encoder = new EncoderImpl(this.decoder);
    private ByteBuffer buffer;

    TestDecoder(byte[] data) {
        AMQPDefinedTypes.registerAllTypes(this.decoder, this.encoder);
        this.buffer = ByteBuffer.allocate(data.length);
        this.buffer.put(data);
        this.buffer.rewind();
        this.decoder.setByteBuffer(this.buffer);
    }

    public Boolean readBoolean() {
        return this.decoder.readBoolean();
    }

    public Byte readByte() {
        return this.decoder.readByte();
    }

    public Short readShort() {
        return this.decoder.readShort();
    }

    public Integer readInteger() {
        return this.decoder.readInteger();
    }

    public Long readLong() {
        return this.decoder.readLong();
    }

    public UnsignedByte readUnsignedByte() {
        return this.decoder.readUnsignedByte();
    }

    public UnsignedShort readUnsignedShort() {
        return this.decoder.readUnsignedShort();
    }

    public UnsignedInteger readUnsignedInteger() {
        return this.decoder.readUnsignedInteger();
    }

    public UnsignedLong readUnsignedLong() {
        return this.decoder.readUnsignedLong();
    }

    public Character readCharacter() {
        return this.decoder.readCharacter();
    }

    public Float readFloat() {
        return this.decoder.readFloat();
    }

    public Double readDouble() {
        return this.decoder.readDouble();
    }

    public UUID readUUID() {
        return this.decoder.readUUID();
    }

    public Decimal32 readDecimal32() {
        return this.decoder.readDecimal32();
    }

    public Decimal64 readDecimal64() {
        return this.decoder.readDecimal64();
    }

    public Decimal128 readDecimal128() {
        return this.decoder.readDecimal128();
    }

    public Date readTimestamp() {
        return this.decoder.readTimestamp();
    }

    public Binary readBinary() {
        return this.decoder.readBinary();
    }

    public Symbol readSymbol() {
        return this.decoder.readSymbol();
    }

    public String readString() {
        return this.decoder.readString();
    }

    public List readList() {
        return this.decoder.readList();
    }

    public Map readMap() {
        return this.decoder.readMap();
    }

    public Object[] readArray() {
        return this.decoder.readArray();
    }

    public boolean[] readBooleanArray() {
        return this.decoder.readBooleanArray();
    }

    public byte[] readByteArray() {
        return this.decoder.readByteArray();
    }

    public short[] readShortArray() {
        return this.decoder.readShortArray();
    }

    public int[] readIntegerArray() {
        return this.decoder.readIntegerArray();
    }

    public long[] readLongArray() {
        return this.decoder.readLongArray();
    }

    public float[] readFloatArray() {
        return this.decoder.readFloatArray();
    }

    public double[] readDoubleArray() {
        return this.decoder.readDoubleArray();
    }

    public char[] readCharacterArray() {
        return this.decoder.readCharacterArray();
    }

    public Object readObject() {
        return this.decoder.readObject();
    }
}

