/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.container.EntryFactory;
import org.infinispan.container.EntryFactoryImpl;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClusteredRepeatableReadEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.transaction.impl.AbstractCacheTransaction;

public class IncrementalVersionableEntryFactoryImpl
extends EntryFactoryImpl {
    private VersionGenerator versionGenerator;

    @Inject
    public void injectVersionGenerator(VersionGenerator versionGenerator) {
        this.versionGenerator = versionGenerator;
    }

    @Override
    protected MVCCEntry createWrappedEntry(Object key, CacheEntry cacheEntry, InvocationContext context, boolean skipRead) {
        Metadata metadata;
        Object value;
        if (cacheEntry != null) {
            value = cacheEntry.getValue();
            metadata = cacheEntry.getMetadata();
        } else {
            value = null;
            metadata = new EmbeddedMetadata.Builder().version(this.versionGenerator.nonExistingVersion()).build();
        }
        if (!skipRead) {
            this.addReadVersion(key, cacheEntry, context, metadata);
        }
        return new ClusteredRepeatableReadEntry(key, value, metadata);
    }

    @Override
    public boolean wrapExternalEntry(InvocationContext ctx, Object key, CacheEntry externalEntry, EntryFactory.Wrap wrap, boolean skipRead) {
        boolean added = super.wrapExternalEntry(ctx, key, externalEntry, wrap, skipRead);
        if (added && ctx.isOriginLocal() && ctx.isInTxScope() && externalEntry != null) {
            EntryVersion version = externalEntry.getMetadata().version();
            ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).replaceVersionRead(key, version);
        }
        return added;
    }

    private void addReadVersion(Object key, CacheEntry cacheEntry, InvocationContext context, Metadata metadata) {
        if (context.isOriginLocal() && context.isInTxScope()) {
            EntryVersion version = cacheEntry != null ? metadata.version() : this.versionGenerator.nonExistingVersion();
            ((AbstractCacheTransaction)((TxInvocationContext)context).getCacheTransaction()).addVersionRead(key, version);
        }
    }
}

