/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.concurrent.locks.LockUtil;
import org.infinispan.util.concurrent.locks.PendingLockManager;
import org.infinispan.util.logging.Log;

public abstract class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    private boolean trace = this.getLog().isTraceEnabled();
    protected RpcManager rpcManager;
    private PartitionHandlingManager partitionHandlingManager;
    private PendingLockManager pendingLockManager;

    @Inject
    public void setDependencies(RpcManager rpcManager, PartitionHandlingManager partitionHandlingManager, PendingLockManager pendingLockManager) {
        this.rpcManager = rpcManager;
        this.partitionHandlingManager = partitionHandlingManager;
        this.pendingLockManager = pendingLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.visitNonTxDataWriteCommand(ctx, command);
        }
        return this.visitDataWriteCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        try {
            Object object = super.visitGetAllCommand(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        boolean releaseLocks = this.releaseLockOnTxCompletion(ctx);
        try {
            Object object = super.visitCommitCommand(ctx, command);
            return object;
        }
        catch (OutdatedTopologyException e) {
            releaseLocks = false;
            throw e;
        }
        finally {
            if (releaseLocks) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    protected final Object invokeNextAndCommitIf1Pc(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit() && this.releaseLockOnTxCompletion(ctx)) {
            this.lockManager.unlockAll(ctx);
        }
        return result;
    }

    protected final boolean lockOrRegisterBackupLock(TxInvocationContext<?> ctx, Object key, long lockTimeout) throws InterruptedException {
        switch (LockUtil.getLockOwnership(key, this.cdl)) {
            case PRIMARY: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring locks on %s.", key);
                }
                this.checkPendingAndLockKey(ctx, key, lockTimeout);
                return true;
            }
            case BACKUP: {
                if (this.trace) {
                    this.getLog().tracef("Acquiring backup locks on %s.", key);
                }
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
                return false;
            }
        }
        return false;
    }

    protected final Collection<Object> lockAllOrRegisterBackupLock(TxInvocationContext<?> ctx, Collection<Object> keys, long lockTimeout) throws InterruptedException {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        Log log = this.getLog();
        boolean trace = log.isTraceEnabled();
        ArrayList<Object> keysToLock = new ArrayList<Object>(keys.size());
        for (Object key : keys) {
            switch (LockUtil.getLockOwnership(key, this.cdl)) {
                case PRIMARY: {
                    if (trace) {
                        log.tracef("Acquiring locks on %s.", key);
                    }
                    keysToLock.add(key);
                    break;
                }
                case BACKUP: {
                    if (trace) {
                        log.tracef("Acquiring backup locks on %s.", key);
                    }
                    ((AbstractCacheTransaction)ctx.getCacheTransaction()).addBackupLockForKey(key);
                    break;
                }
            }
        }
        if (keysToLock.isEmpty()) {
            return Collections.emptyList();
        }
        this.checkPendingAndLockAllKeys(ctx, keysToLock, lockTimeout);
        return keysToLock;
    }

    private void checkPendingAndLockKey(InvocationContext ctx, Object key, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForKey((TxInvocationContext)ctx, key, lockTimeout, TimeUnit.MILLISECONDS);
        this.lockAndRecord(ctx, key, remaining);
    }

    private void checkPendingAndLockAllKeys(InvocationContext ctx, Collection<Object> keys, long lockTimeout) throws InterruptedException {
        long remaining = this.pendingLockManager.awaitPendingTransactionsForAllKeys((TxInvocationContext)ctx, keys, lockTimeout, TimeUnit.MILLISECONDS);
        this.lockAllAndRecord(ctx, keys, remaining);
    }

    private boolean releaseLockOnTxCompletion(TxInvocationContext ctx) {
        return ctx.isOriginLocal() && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction()) || !ctx.isOriginLocal() && Configurations.isSecondPhaseAsync(this.cacheConfiguration);
    }
}

