/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    private static final Logger logger = LoggerFactory.getLogger(Metadata.class);
    final Cluster.Manager cluster;
    volatile String clusterName;
    volatile String partitioner;
    private final ConcurrentMap<InetSocketAddress, Host> hosts = new ConcurrentHashMap<InetSocketAddress, Host>();
    final ConcurrentMap<String, KeyspaceMetadata> keyspaces = new ConcurrentHashMap<String, KeyspaceMetadata>();
    private volatile TokenMap tokenMap;
    final ReentrantLock lock = new ReentrantLock();
    private static final Pattern alphanumeric = Pattern.compile("\\w+");
    private static final Pattern lowercaseAlphanumeric = Pattern.compile("[a-z][a-z0-9_]*");
    private static final Set<String> RESERVED_KEYWORDS = ImmutableSet.of((Object)"add", (Object)"allow", (Object)"alter", (Object)"and", (Object)"any", (Object)"apply", (Object[])new String[]{"asc", "authorize", "batch", "begin", "by", "columnfamily", "create", "delete", "desc", "drop", "each_quorum", "from", "grant", "in", "index", "inet", "infinity", "insert", "into", "keyspace", "keyspaces", "limit", "local_one", "local_quorum", "modify", "nan", "norecursive", "of", "on", "one", "order", "password", "primary", "quorum", "rename", "revoke", "schema", "select", "set", "table", "to", "token", "three", "truncate", "two", "unlogged", "update", "use", "using", "where", "with"});

    Metadata(Cluster.Manager cluster) {
        this.cluster = cluster;
    }

    void rebuildTokenMap() {
        this.lock.lock();
        try {
            if (this.tokenMap == null) {
                return;
            }
            this.tokenMap = TokenMap.build(this.tokenMap.factory, this.tokenMap.primaryToTokens, this.keyspaces.values(), this.tokenMap.ring, this.tokenMap.tokenRanges, this.tokenMap.tokenToPrimary);
        }
        finally {
            this.lock.unlock();
        }
    }

    void rebuildTokenMap(Token.Factory factory, Map<Host, Set<Token>> allTokens) {
        this.lock.lock();
        try {
            this.tokenMap = TokenMap.build(factory, allTokens, this.keyspaces.values());
        }
        finally {
            this.lock.unlock();
        }
    }

    Host newHost(InetSocketAddress address) {
        return new Host(address, this.cluster.convictionPolicyFactory, this.cluster);
    }

    Host addIfAbsent(Host host) {
        Host previous = this.hosts.putIfAbsent(host.getSocketAddress(), host);
        return previous == null ? host : null;
    }

    Host add(InetSocketAddress address) {
        return this.addIfAbsent(this.newHost(address));
    }

    boolean remove(Host host) {
        return this.hosts.remove(host.getSocketAddress()) != null;
    }

    Host getHost(InetSocketAddress address) {
        return (Host)this.hosts.get(address);
    }

    Collection<Host> allHosts() {
        return this.hosts.values();
    }

    static String handleId(String id) {
        if (id == null) {
            return null;
        }
        if (alphanumeric.matcher(id).matches()) {
            return id.toLowerCase();
        }
        return ParseUtils.unDoubleQuote(id);
    }

    static String escapeId(String ident) {
        return lowercaseAlphanumeric.matcher(ident).matches() && !Metadata.isReservedCqlKeyword(ident) ? ident : Metadata.quote(ident);
    }

    static String fullFunctionName(String simpleName, Collection<?> argumentTypes) {
        StringBuilder sb = new StringBuilder(simpleName);
        sb.append('(');
        boolean first = true;
        for (Object argumentType : argumentTypes) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (argumentType instanceof UserType) {
                UserType userType = (UserType)argumentType;
                String typeName = Metadata.escapeId(userType.getTypeName());
                if (userType.isFrozen()) {
                    sb.append("frozen<");
                }
                sb.append(typeName);
                if (!userType.isFrozen()) continue;
                sb.append(">");
                continue;
            }
            sb.append(argumentType);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String quote(String id) {
        return ParseUtils.doubleQuote(id);
    }

    public static boolean isReservedCqlKeyword(String id) {
        return id != null && RESERVED_KEYWORDS.contains(id.toLowerCase());
    }

    public Set<TokenRange> getTokenRanges() {
        TokenMap current = this.tokenMap;
        return current == null ? Collections.emptySet() : current.tokenRanges;
    }

    public Set<TokenRange> getTokenRanges(String keyspace, Host host) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Map dcRanges = (Map)current.hostsToRangesByKeyspace.get(keyspace);
        if (dcRanges == null) {
            return Collections.emptySet();
        }
        Set ranges = (Set)dcRanges.get(host);
        return ranges == null ? Collections.emptySet() : ranges;
    }

    public Set<Host> getReplicas(String keyspace, ByteBuffer partitionKey) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Set hosts = current.getReplicas(keyspace, current.factory.hash(partitionKey));
        return hosts == null ? Collections.emptySet() : hosts;
    }

    public Set<Host> getReplicas(String keyspace, TokenRange range) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Set hosts = current.getReplicas(keyspace, range.getEnd());
        return hosts == null ? Collections.emptySet() : hosts;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public Set<Host> getAllHosts() {
        return new HashSet<Host>(this.allHosts());
    }

    public boolean checkSchemaAgreement() {
        try {
            return this.cluster.controlConnection.checkSchemaAgreement();
        }
        catch (Exception e) {
            logger.warn("Error while checking schema agreement", (Throwable)e);
            return false;
        }
    }

    public KeyspaceMetadata getKeyspace(String keyspace) {
        return (KeyspaceMetadata)this.keyspaces.get(Metadata.handleId(keyspace));
    }

    KeyspaceMetadata removeKeyspace(String keyspace) {
        KeyspaceMetadata removed = (KeyspaceMetadata)this.keyspaces.remove(keyspace);
        if (this.tokenMap != null) {
            this.tokenMap.tokenToHostsByKeyspace.remove(keyspace);
        }
        return removed;
    }

    public List<KeyspaceMetadata> getKeyspaces() {
        return new ArrayList<KeyspaceMetadata>(this.keyspaces.values());
    }

    public String exportSchemaAsString() {
        StringBuilder sb = new StringBuilder();
        for (KeyspaceMetadata ksm : this.keyspaces.values()) {
            sb.append(ksm.exportAsString()).append('\n');
        }
        return sb.toString();
    }

    public TupleType newTupleType(DataType ... types) {
        return this.newTupleType(Arrays.asList(types));
    }

    public TupleType newTupleType(List<DataType> types) {
        return new TupleType(types, this.cluster.protocolVersion(), this.cluster.configuration.getCodecRegistry());
    }

    public Token newToken(String tokenStr) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            throw new IllegalStateException("Token factory not set. This should only happen if metadata was explicitly disabled");
        }
        return current.factory.fromString(tokenStr);
    }

    public Token newToken(ByteBuffer ... components) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            throw new IllegalStateException("Token factory not set. This should only happen if metadata was explicitly disabled");
        }
        return current.factory.hash(SimpleStatement.compose(components));
    }

    public TokenRange newTokenRange(Token start, Token end) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            throw new IllegalStateException("Token factory not set. This should only happen if metadata was explicitly disabled");
        }
        return new TokenRange(start, end, current.factory);
    }

    Token.Factory tokenFactory() {
        TokenMap current = this.tokenMap;
        return current == null ? null : current.factory;
    }

    void triggerOnKeyspaceAdded(KeyspaceMetadata keyspace) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onKeyspaceAdded(keyspace);
        }
    }

    void triggerOnKeyspaceChanged(KeyspaceMetadata current, KeyspaceMetadata previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onKeyspaceChanged(current, previous);
        }
    }

    void triggerOnKeyspaceRemoved(KeyspaceMetadata keyspace) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onKeyspaceRemoved(keyspace);
        }
    }

    void triggerOnTableAdded(TableMetadata table) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onTableAdded(table);
        }
    }

    void triggerOnTableChanged(TableMetadata current, TableMetadata previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onTableChanged(current, previous);
        }
    }

    void triggerOnTableRemoved(TableMetadata table) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onTableRemoved(table);
        }
    }

    void triggerOnUserTypeAdded(UserType type) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onUserTypeAdded(type);
        }
    }

    void triggerOnUserTypeChanged(UserType current, UserType previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onUserTypeChanged(current, previous);
        }
    }

    void triggerOnUserTypeRemoved(UserType type) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onUserTypeRemoved(type);
        }
    }

    void triggerOnFunctionAdded(FunctionMetadata function) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onFunctionAdded(function);
        }
    }

    void triggerOnFunctionChanged(FunctionMetadata current, FunctionMetadata previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onFunctionChanged(current, previous);
        }
    }

    void triggerOnFunctionRemoved(FunctionMetadata function) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onFunctionRemoved(function);
        }
    }

    void triggerOnAggregateAdded(AggregateMetadata aggregate) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onAggregateAdded(aggregate);
        }
    }

    void triggerOnAggregateChanged(AggregateMetadata current, AggregateMetadata previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onAggregateChanged(current, previous);
        }
    }

    void triggerOnAggregateRemoved(AggregateMetadata aggregate) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onAggregateRemoved(aggregate);
        }
    }

    void triggerOnMaterializedViewAdded(MaterializedViewMetadata view) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onMaterializedViewAdded(view);
        }
    }

    void triggerOnMaterializedViewChanged(MaterializedViewMetadata current, MaterializedViewMetadata previous) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onMaterializedViewChanged(current, previous);
        }
    }

    void triggerOnMaterializedViewRemoved(MaterializedViewMetadata view) {
        for (SchemaChangeListener listener : this.cluster.schemaChangeListeners) {
            listener.onMaterializedViewRemoved(view);
        }
    }

    private static class TokenMap {
        private final Token.Factory factory;
        private final Map<Host, Set<Token>> primaryToTokens;
        private final Map<String, Map<Token, Set<Host>>> tokenToHostsByKeyspace;
        private final Map<String, Map<Host, Set<TokenRange>>> hostsToRangesByKeyspace;
        private final List<Token> ring;
        private final Set<TokenRange> tokenRanges;
        private final Map<Token, Host> tokenToPrimary;

        private TokenMap(Token.Factory factory, List<Token> ring, Set<TokenRange> tokenRanges, Map<Token, Host> tokenToPrimary, Map<Host, Set<Token>> primaryToTokens, Map<String, Map<Token, Set<Host>>> tokenToHostsByKeyspace, Map<String, Map<Host, Set<TokenRange>>> hostsToRangesByKeyspace) {
            this.factory = factory;
            this.ring = ring;
            this.tokenRanges = tokenRanges;
            this.tokenToPrimary = tokenToPrimary;
            this.primaryToTokens = primaryToTokens;
            this.tokenToHostsByKeyspace = tokenToHostsByKeyspace;
            this.hostsToRangesByKeyspace = hostsToRangesByKeyspace;
            for (Map.Entry<Host, Set<Token>> entry : primaryToTokens.entrySet()) {
                Host host = entry.getKey();
                host.setTokens((Set<Token>)ImmutableSet.copyOf((Collection)entry.getValue()));
            }
        }

        private static TokenMap build(Token.Factory factory, Map<Host, Set<Token>> allTokens, Collection<KeyspaceMetadata> keyspaces) {
            HashMap<Token, Host> tokenToPrimary = new HashMap<Token, Host>();
            TreeSet<Token> allSorted = new TreeSet<Token>();
            for (Map.Entry<Host, Set<Token>> entry : allTokens.entrySet()) {
                Host host = entry.getKey();
                for (Token t : (Collection)entry.getValue()) {
                    try {
                        allSorted.add(t);
                        tokenToPrimary.put(t, host);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            ArrayList<Token> ring = new ArrayList<Token>(allSorted);
            Set<TokenRange> tokenRanges = TokenMap.makeTokenRanges(ring, factory);
            return TokenMap.build(factory, allTokens, keyspaces, ring, tokenRanges, tokenToPrimary);
        }

        private static TokenMap build(Token.Factory factory, Map<Host, Set<Token>> allTokens, Collection<KeyspaceMetadata> keyspaces, List<Token> ring, Set<TokenRange> tokenRanges, Map<Token, Host> tokenToPrimary) {
            Set<Host> hosts = allTokens.keySet();
            HashMap<String, Map<Token, Set<Host>>> tokenToHosts = new HashMap<String, Map<Token, Set<Host>>>();
            HashMap<ReplicationStrategy, Map<Token, Set<Host>>> replStrategyToHosts = new HashMap<ReplicationStrategy, Map<Token, Set<Host>>>();
            HashMap<String, Map<Host, Set<TokenRange>>> hostsToRanges = new HashMap<String, Map<Host, Set<TokenRange>>>();
            for (KeyspaceMetadata keyspace : keyspaces) {
                ImmutableMap ksRanges;
                ReplicationStrategy strategy = keyspace.replicationStrategy();
                Map<Token, Set<Host>> ksTokens = (Map<Token, Set<Host>>)replStrategyToHosts.get(strategy);
                if (ksTokens == null) {
                    ksTokens = strategy == null ? TokenMap.makeNonReplicatedMap(tokenToPrimary) : strategy.computeTokenToReplicaMap(keyspace.getName(), tokenToPrimary, ring);
                    replStrategyToHosts.put(strategy, ksTokens);
                }
                tokenToHosts.put(keyspace.getName(), ksTokens);
                if (ring.size() == 1) {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    for (Host host : allTokens.keySet()) {
                        builder.put((Object)host, tokenRanges);
                    }
                    ksRanges = builder.build();
                } else {
                    ksRanges = TokenMap.computeHostsToRangesMap(tokenRanges, ksTokens, hosts.size());
                }
                hostsToRanges.put(keyspace.getName(), (Map<Host, Set<TokenRange>>)ksRanges);
            }
            return new TokenMap(factory, ring, tokenRanges, tokenToPrimary, allTokens, tokenToHosts, hostsToRanges);
        }

        private Set<Host> getReplicas(String keyspace, Token token) {
            Map<Token, Set<Host>> tokenToHosts = this.tokenToHostsByKeyspace.get(keyspace);
            if (tokenToHosts == null) {
                return Collections.emptySet();
            }
            Set<Host> hosts = tokenToHosts.get(token);
            if (hosts != null) {
                return hosts;
            }
            int i = Collections.binarySearch(this.ring, token);
            if (i < 0 && (i = -i - 1) >= this.ring.size()) {
                i = 0;
            }
            return tokenToHosts.get(this.ring.get(i));
        }

        private static Map<Token, Set<Host>> makeNonReplicatedMap(Map<Token, Host> input) {
            HashMap<Token, Set<Host>> output = new HashMap<Token, Set<Host>>(input.size());
            for (Map.Entry<Token, Host> entry : input.entrySet()) {
                output.put(entry.getKey(), (Set<Host>)ImmutableSet.of((Object)entry.getValue()));
            }
            return output;
        }

        private static Set<TokenRange> makeTokenRanges(List<Token> ring, Token.Factory factory) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ring.size() == 1) {
                builder.add((Object)new TokenRange(factory.minToken(), factory.minToken(), factory));
            } else {
                for (int i = 0; i < ring.size(); ++i) {
                    Token start = ring.get(i);
                    Token end = ring.get((i + 1) % ring.size());
                    builder.add((Object)new TokenRange(start, end, factory));
                }
            }
            return builder.build();
        }

        private static Map<Host, Set<TokenRange>> computeHostsToRangesMap(Set<TokenRange> tokenRanges, Map<Token, Set<Host>> ksTokens, int hostCount) {
            HashMap builders = Maps.newHashMapWithExpectedSize((int)hostCount);
            for (TokenRange range : tokenRanges) {
                Set<Host> replicas = ksTokens.get(range.getEnd());
                for (Host host : replicas) {
                    ImmutableSet.Builder hostRanges = (ImmutableSet.Builder)builders.get(host);
                    if (hostRanges == null) {
                        hostRanges = ImmutableSet.builder();
                        builders.put(host, hostRanges);
                    }
                    hostRanges.add((Object)range);
                }
            }
            HashMap ksRanges = Maps.newHashMapWithExpectedSize((int)hostCount);
            for (Map.Entry entry : builders.entrySet()) {
                ksRanges.put(entry.getKey(), ((ImmutableSet.Builder)entry.getValue()).build());
            }
            return ksRanges;
        }
    }
}

