/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.RestartApplicationRequest;
import org.hawkular.cmdgw.api.RestartApplicationResponse;
import org.hawkular.dmrclient.DeploymentJBossASClient;
import org.hawkular.inventory.paths.CanonicalPath;
import org.jboss.as.controller.client.ModelControllerClient;

public class RestartApplicationCommand
extends AbstractResourcePathCommand<RestartApplicationRequest, RestartApplicationResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(RestartApplicationCommand.class);
    public static final Class<RestartApplicationRequest> REQUEST_CLASS = RestartApplicationRequest.class;
    public static final String NAME = "Restart Deployment";

    public RestartApplicationCommand() {
        super(NAME, "Application");
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<RestartApplicationRequest> envelope, RestartApplicationResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        RestartApplicationRequest request = (RestartApplicationRequest)envelope.getBasicMessage();
        String resourcePath = request.getResourcePath();
        String destFileName = request.getDestinationFileName();
        Set<String> serverGroups = this.convertCsvToSet(request.getServerGroups());
        CanonicalPath canonicalPath = CanonicalPath.fromString((String)request.getResourcePath());
        String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
        ResourceManager<DMRNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<DMRNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot restart application: unknown resource [%s]", resourcePath));
        }
        Collection<Operation<DMRNodeLocation>> ops = resource.getResourceType().getOperations();
        boolean canPerform = false;
        log.tracef("Searching for [%s] operation among operations [%s] for resource [%s].", NAME, ops, resource.getID());
        for (Operation<DMRNodeLocation> op : ops) {
            if (!NAME.equals(op.getName().getNameString())) continue;
            canPerform = true;
            break;
        }
        if (!canPerform) {
            throw new IllegalArgumentException(String.format("Cannot [%s] from [%s]. The operation is undefined.", NAME, resource));
        }
        MessageUtils.prepareResourcePathResponse((ResourcePathRequest)request, (ResourcePathResponse)response);
        response.setDestinationFileName(request.getDestinationFileName());
        DeploymentJBossASClient client = new DeploymentJBossASClient(dmrContext.getClient());
        client.restartDeployment(destFileName, serverGroups);
        endpointService.discoverAll();
        return null;
    }

    private Set<String> convertCsvToSet(String serverGroups) {
        if (serverGroups == null || serverGroups.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(serverGroups.split(",")));
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<RestartApplicationRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<RestartApplicationRequest> envelope, MonitoredEndpoint<? extends MonitorServiceConfiguration.AbstractEndpointConfiguration> endpoint) {
    }

    @Override
    protected RestartApplicationResponse createResponse() {
        return new RestartApplicationResponse();
    }
}

