/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.extension.MonitorServiceConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.ProtocolService;
import org.hawkular.agent.monitor.protocol.dmr.DMREndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.agent.monitor.protocol.jmx.JMXEndpointService;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.agent.monitor.protocol.platform.PlatformEndpointService;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformSession;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;
import org.jboss.msc.value.InjectedValue;

public class ProtocolServices {
    public static final int DEFAULT_AUTO_DISCOVERY_SCAN_PERIOD_SECS = 3600;
    private static final MsgLogger log = AgentLoggers.getLogger(ProtocolServices.class);
    private final ProtocolService<DMRNodeLocation, DMRSession> dmrProtocolService;
    private final ProtocolService<JMXNodeLocation, JMXSession> jmxProtocolService;
    private final ProtocolService<PlatformNodeLocation, PlatformSession> platformProtocolService;
    private final List<ProtocolService<?, ?>> services;
    private final int autoDiscoveryScanPeriodSecs;
    private ScheduledExecutorService autoDiscoveryExecutor = null;

    public static Builder builder(String feedId, Diagnostics diagnostics, Map<String, InjectedValue<SSLContext>> sslContexts) {
        return new Builder(feedId, sslContexts, diagnostics);
    }

    public ProtocolServices(ProtocolService<DMRNodeLocation, DMRSession> dmrProtocolService, ProtocolService<JMXNodeLocation, JMXSession> jmxProtocolService, ProtocolService<PlatformNodeLocation, PlatformSession> platformProtocolService, int autoDiscoveryScanPeriodSecs) {
        this.dmrProtocolService = dmrProtocolService;
        this.jmxProtocolService = jmxProtocolService;
        this.platformProtocolService = platformProtocolService;
        this.services = Collections.unmodifiableList(Arrays.asList(dmrProtocolService, jmxProtocolService, platformProtocolService));
        this.autoDiscoveryScanPeriodSecs = autoDiscoveryScanPeriodSecs;
    }

    public void start() {
        for (ProtocolService<?, ?> service : this.services) {
            service.start();
        }
        this.startAutoDiscovery();
    }

    public void discoverAll() {
        for (ProtocolService<?, ?> service : this.services) {
            service.discoverAll();
        }
    }

    public void stop() {
        this.stopAutoDiscovery();
        for (ProtocolService<?, ?> service : this.services) {
            service.stop();
        }
    }

    public void addInventoryListener(InventoryListener listener) {
        for (ProtocolService<?, ?> service : this.services) {
            service.addInventoryListener(listener);
        }
    }

    public void removeInventoryListener(InventoryListener listener) {
        for (ProtocolService<?, ?> service : this.services) {
            service.removeInventoryListener(listener);
        }
    }

    public ProtocolService<DMRNodeLocation, DMRSession> getDmrProtocolService() {
        return this.dmrProtocolService;
    }

    public ProtocolService<JMXNodeLocation, JMXSession> getJmxProtocolService() {
        return this.jmxProtocolService;
    }

    public ProtocolService<PlatformNodeLocation, PlatformSession> getPlatformProtocolService() {
        return this.platformProtocolService;
    }

    public List<ProtocolService<?, ?>> getServices() {
        return this.services;
    }

    private void startAutoDiscovery() {
        if (this.autoDiscoveryScanPeriodSecs > 0) {
            log.infoAutoDiscoveryEnabled(this.autoDiscoveryScanPeriodSecs);
            ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, "Hawkular WildFly Agent Auto-Discovery Scan");
            this.autoDiscoveryExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    try {
                        ProtocolServices.this.discoverAll();
                    }
                    catch (Throwable t) {
                        log.errorAutoDiscoveryFailed(t);
                    }
                }
            };
            this.autoDiscoveryExecutor.scheduleAtFixedRate(job, 0L, this.autoDiscoveryScanPeriodSecs, TimeUnit.SECONDS);
        } else {
            log.infoAutoDiscoveryDisabled();
            this.autoDiscoveryExecutor = null;
            try {
                this.discoverAll();
            }
            catch (Throwable t) {
                log.errorAutoDiscoveryFailed(t);
            }
        }
    }

    private void stopAutoDiscovery() {
        if (this.autoDiscoveryExecutor != null) {
            log.debugf("Shutting down auto-discovery job", new Object[0]);
            this.autoDiscoveryExecutor.shutdownNow();
        }
    }

    public static class Builder {
        private final String feedId;
        private ProtocolService<DMRNodeLocation, DMRSession> dmrProtocolService;
        private ProtocolService<JMXNodeLocation, JMXSession> jmxProtocolService;
        private ProtocolService<PlatformNodeLocation, PlatformSession> platformProtocolService;
        private final Map<String, InjectedValue<SSLContext>> sslContexts;
        private final Diagnostics diagnostics;
        private int autoDiscoveryScanPeriodSecs;

        public Builder(String feedId, Map<String, InjectedValue<SSLContext>> sslContexts, Diagnostics diagnostics) {
            this.feedId = feedId;
            this.sslContexts = sslContexts;
            this.diagnostics = diagnostics;
            this.autoDiscoveryScanPeriodSecs = 3600;
        }

        public ProtocolServices build() {
            return new ProtocolServices(this.dmrProtocolService, this.jmxProtocolService, this.platformProtocolService, this.autoDiscoveryScanPeriodSecs);
        }

        public Builder autoDiscoveryScanPeriodSecs(int periodSecs) {
            this.autoDiscoveryScanPeriodSecs = periodSecs;
            return this;
        }

        public Builder dmrProtocolService(ModelControllerClientFactory localModelControllerClientFactory, MonitorServiceConfiguration.ProtocolConfiguration<DMRNodeLocation> protocolConfig) {
            ProtocolService.Builder<DMRNodeLocation, DMRSession> builder = ProtocolService.builder("DMR");
            for (MonitorServiceConfiguration.EndpointConfiguration server : protocolConfig.getEndpoints().values()) {
                if (!server.isEnabled()) {
                    log.infoManagedServerDisabled(server.getName().toString());
                    continue;
                }
                String securityRealm = server.getSecurityRealm();
                SSLContext sslContext = null;
                if (securityRealm != null) {
                    InjectedValue<SSLContext> injectedValue = this.sslContexts.get(securityRealm);
                    if (injectedValue == null) {
                        throw new IllegalArgumentException("Unknown security realm: " + securityRealm);
                    }
                    sslContext = (SSLContext)injectedValue.getOptionalValue();
                }
                MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint = MonitoredEndpoint.of(server, sslContext);
                ModelControllerClientFactory clientFactory = server.isLocal() ? localModelControllerClientFactory : ModelControllerClientFactory.createRemote(endpoint);
                ResourceTypeManager<DMRNodeLocation> resourceTypeManager = new ResourceTypeManager<DMRNodeLocation>(protocolConfig.getTypeSets().getResourceTypeSets(), server.getResourceTypeSets());
                DMREndpointService endpointService = new DMREndpointService(this.feedId, endpoint, resourceTypeManager, clientFactory, this.diagnostics.getDMRDiagnostics());
                builder.endpointService(endpointService);
                log.debugf("[%s] created with resource type sets [%s]", endpointService, server.getResourceTypeSets());
            }
            this.dmrProtocolService = builder.build();
            return this;
        }

        public Builder jmxProtocolService(MonitorServiceConfiguration.ProtocolConfiguration<JMXNodeLocation> protocolConfig) {
            ProtocolService.Builder<JMXNodeLocation, JMXSession> builder = ProtocolService.builder("JMX");
            for (MonitorServiceConfiguration.EndpointConfiguration server : protocolConfig.getEndpoints().values()) {
                if (!server.isEnabled()) continue;
                String securityRealm = server.getSecurityRealm();
                SSLContext sslContext = null;
                if (securityRealm != null) {
                    InjectedValue<SSLContext> injectedValue = this.sslContexts.get(securityRealm);
                    if (injectedValue == null) {
                        throw new IllegalArgumentException("Unknown security realm: " + securityRealm);
                    }
                    sslContext = (SSLContext)injectedValue.getOptionalValue();
                }
                MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint = MonitoredEndpoint.of(server, sslContext);
                ResourceTypeManager<JMXNodeLocation> resourceTypeManager = new ResourceTypeManager<JMXNodeLocation>(protocolConfig.getTypeSets().getResourceTypeSets(), server.getResourceTypeSets());
                JMXEndpointService endpointService = new JMXEndpointService(this.feedId, endpoint, resourceTypeManager, this.diagnostics.getJMXDiagnostics());
                builder.endpointService(endpointService);
                log.debugf("[%s] created with resource type sets [%s]", endpointService, server.getResourceTypeSets());
            }
            this.jmxProtocolService = builder.build();
            return this;
        }

        public Builder platformProtocolService(MonitorServiceConfiguration.ProtocolConfiguration<PlatformNodeLocation> protocolConfig) {
            ProtocolService.Builder<PlatformNodeLocation, PlatformSession> builder = ProtocolService.builder("Platform");
            for (MonitorServiceConfiguration.EndpointConfiguration server : protocolConfig.getEndpoints().values()) {
                if (!server.isEnabled()) continue;
                String securityRealm = server.getSecurityRealm();
                SSLContext sslContext = null;
                if (securityRealm != null) {
                    InjectedValue<SSLContext> injectedValue = this.sslContexts.get(securityRealm);
                    if (injectedValue == null) {
                        throw new IllegalArgumentException("Unknown security realm: " + securityRealm);
                    }
                    sslContext = (SSLContext)injectedValue.getOptionalValue();
                }
                MonitoredEndpoint<MonitorServiceConfiguration.EndpointConfiguration> endpoint = MonitoredEndpoint.of(server, sslContext);
                ResourceTypeManager<PlatformNodeLocation> resourceTypeManager = new ResourceTypeManager<PlatformNodeLocation>(protocolConfig.getTypeSets().getResourceTypeSets(), server.getResourceTypeSets());
                PlatformEndpointService endpointService = new PlatformEndpointService(this.feedId, endpoint, resourceTypeManager, this.diagnostics.getPlatformDiagnostics());
                builder.endpointService(endpointService);
                log.debugf("[%s] created with resource type sets [%s]", endpointService, server.getResourceTypeSets());
            }
            this.platformProtocolService = builder.build();
            return this;
        }
    }
}

