/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.LocalSocketAddress;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.AcceptListenerSettable;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.UnsupportedOptionException;
import org.xnio.management.XnioServerMXBean;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioSocketStreamConnection;
import org.xnio.nio.NioXnio;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.QueuedNioTcpServerHandle;
import org.xnio.nio.WorkerThread;

final class QueuedNioTcpServer
extends AbstractNioChannel<QueuedNioTcpServer>
implements AcceptingChannel<StreamConnection>,
AcceptListenerSettable<QueuedNioTcpServer> {
    private static final String FQCN = QueuedNioTcpServer.class.getName();
    private volatile ChannelListener<? super QueuedNioTcpServer> acceptListener;
    private final QueuedNioTcpServerHandle handle;
    private final WorkerThread thread;
    private final ServerSocketChannel channel;
    private final ServerSocket socket;
    private final Closeable mbeanHandle;
    private final List<BlockingQueue<SocketChannel>> acceptQueues;
    private static final Set<Option<?>> options = Option.setBuilder().add(Options.REUSE_ADDRESSES).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.KEEP_ALIVE).add(Options.TCP_OOB_INLINE).add(Options.TCP_NODELAY).add(Options.CONNECTION_HIGH_WATER).add(Options.CONNECTION_LOW_WATER).add(Options.READ_TIMEOUT).add(Options.WRITE_TIMEOUT).create();
    private volatile int keepAlive;
    private volatile int oobInline;
    private volatile int tcpNoDelay;
    private volatile int sendBuffer = -1;
    private volatile long connectionStatus = 0x3FFFFFFFFFFFFFFFL;
    private volatile int readTimeout;
    private volatile int writeTimeout;
    private static final long CONN_LOW_MASK = Integer.MAX_VALUE;
    private static final long CONN_LOW_BIT = 0L;
    private static final long CONN_LOW_ONE = 1L;
    private static final long CONN_HIGH_MASK = 4611686016279904256L;
    private static final long CONN_HIGH_BIT = 31L;
    private static final long CONN_HIGH_ONE = 0x80000000L;
    private static final AtomicIntegerFieldUpdater<QueuedNioTcpServer> keepAliveUpdater = AtomicIntegerFieldUpdater.newUpdater(QueuedNioTcpServer.class, "keepAlive");
    private static final AtomicIntegerFieldUpdater<QueuedNioTcpServer> oobInlineUpdater = AtomicIntegerFieldUpdater.newUpdater(QueuedNioTcpServer.class, "oobInline");
    private static final AtomicIntegerFieldUpdater<QueuedNioTcpServer> tcpNoDelayUpdater = AtomicIntegerFieldUpdater.newUpdater(QueuedNioTcpServer.class, "tcpNoDelay");
    private static final AtomicIntegerFieldUpdater<QueuedNioTcpServer> sendBufferUpdater = AtomicIntegerFieldUpdater.newUpdater(QueuedNioTcpServer.class, "sendBuffer");
    private static final AtomicIntegerFieldUpdater<QueuedNioTcpServer> readTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(QueuedNioTcpServer.class, "readTimeout");
    private static final AtomicIntegerFieldUpdater<QueuedNioTcpServer> writeTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(QueuedNioTcpServer.class, "writeTimeout");
    private static final AtomicLongFieldUpdater<QueuedNioTcpServer> connectionStatusUpdater = AtomicLongFieldUpdater.newUpdater(QueuedNioTcpServer.class, "connectionStatus");
    private final Runnable acceptTask = new Runnable(){

        @Override
        public void run() {
            WorkerThread current = WorkerThread.getCurrent();
            assert (current != null);
            BlockingQueue queue = (BlockingQueue)QueuedNioTcpServer.this.acceptQueues.get(current.getNumber());
            ChannelListeners.invokeChannelListener((Channel)((Object)QueuedNioTcpServer.this), QueuedNioTcpServer.this.getAcceptListener());
            if (!queue.isEmpty()) {
                current.execute(this);
            }
        }
    };

    QueuedNioTcpServer(final NioXnioWorker worker, ServerSocketChannel channel, OptionMap optionMap) throws IOException {
        super(worker);
        int lowWater;
        int highWater;
        this.channel = channel;
        this.thread = worker.getAcceptThread();
        WorkerThread[] workerThreads = worker.getAll();
        ArrayList<BlockingQueue<SocketChannel>> acceptQueues = new ArrayList<BlockingQueue<SocketChannel>>(workerThreads.length);
        for (int i = 0; i < workerThreads.length; ++i) {
            acceptQueues.add(i, new LinkedBlockingQueue());
        }
        this.acceptQueues = acceptQueues;
        this.socket = channel.socket();
        if (optionMap.contains(Options.SEND_BUFFER)) {
            int sendBufferSize = optionMap.get(Options.SEND_BUFFER, 65536);
            if (sendBufferSize < 1) {
                throw Log.log.parameterOutOfRange("sendBufferSize");
            }
            sendBufferUpdater.set(this, sendBufferSize);
        }
        if (optionMap.contains(Options.KEEP_ALIVE)) {
            keepAliveUpdater.lazySet(this, optionMap.get(Options.KEEP_ALIVE, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.TCP_OOB_INLINE)) {
            oobInlineUpdater.lazySet(this, optionMap.get(Options.TCP_OOB_INLINE, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.TCP_NODELAY)) {
            tcpNoDelayUpdater.lazySet(this, optionMap.get(Options.TCP_NODELAY, false) ? 1 : 0);
        }
        if (optionMap.contains(Options.READ_TIMEOUT)) {
            readTimeoutUpdater.lazySet(this, optionMap.get(Options.READ_TIMEOUT, 0));
        }
        if (optionMap.contains(Options.WRITE_TIMEOUT)) {
            writeTimeoutUpdater.lazySet(this, optionMap.get(Options.WRITE_TIMEOUT, 0));
        }
        if (optionMap.contains(Options.CONNECTION_HIGH_WATER) || optionMap.contains(Options.CONNECTION_LOW_WATER)) {
            highWater = optionMap.get(Options.CONNECTION_HIGH_WATER, Integer.MAX_VALUE);
            lowWater = optionMap.get(Options.CONNECTION_LOW_WATER, highWater);
            if (highWater <= 0) {
                throw QueuedNioTcpServer.badHighWater();
            }
            if (lowWater <= 0 || lowWater > highWater) {
                throw QueuedNioTcpServer.badLowWater(highWater);
            }
            long highLowWater = (long)highWater << 31 | (long)lowWater << 0;
            connectionStatusUpdater.lazySet(this, highLowWater);
        } else {
            highWater = Integer.MAX_VALUE;
            lowWater = Integer.MAX_VALUE;
            connectionStatusUpdater.lazySet(this, 0x3FFFFFFFFFFFFFFFL);
        }
        SelectionKey key = this.thread.registerChannel(channel);
        this.handle = new QueuedNioTcpServerHandle(this, this.thread, key, highWater, lowWater);
        key.attach(this.handle);
        this.mbeanHandle = NioXnio.register(new XnioServerMXBean(){

            public String getProviderName() {
                return "nio";
            }

            public String getWorkerName() {
                return worker.getName();
            }

            public String getBindAddress() {
                return String.valueOf(QueuedNioTcpServer.this.getLocalAddress());
            }

            public int getConnectionCount() {
                return QueuedNioTcpServer.this.handle.getConnectionCount();
            }

            public int getConnectionLimitHighWater() {
                return QueuedNioTcpServer.getHighWater(QueuedNioTcpServer.this.connectionStatus);
            }

            public int getConnectionLimitLowWater() {
                return QueuedNioTcpServer.getLowWater(QueuedNioTcpServer.this.connectionStatus);
            }
        });
    }

    private static IllegalArgumentException badLowWater(int highWater) {
        return new IllegalArgumentException("Low water must be greater than 0 and less than or equal to high water (" + highWater + ")");
    }

    private static IllegalArgumentException badHighWater() {
        return new IllegalArgumentException("High water must be greater than 0");
    }

    public void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            this.handle.getWorkerThread().cancelKey(this.handle.getSelectionKey());
            IoUtils.safeClose((Closeable)this.mbeanHandle);
        }
    }

    public boolean supportsOption(Option<?> option) {
        return options.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (option == Options.REUSE_ADDRESSES) {
            return (T)option.cast((Object)this.socket.getReuseAddress());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)this.socket.getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            int value = this.sendBuffer;
            return (T)(value == -1 ? null : option.cast((Object)value));
        }
        if (option == Options.KEEP_ALIVE) {
            return (T)option.cast((Object)(this.keepAlive != 0 ? 1 : 0));
        }
        if (option == Options.TCP_OOB_INLINE) {
            return (T)option.cast((Object)(this.oobInline != 0 ? 1 : 0));
        }
        if (option == Options.TCP_NODELAY) {
            return (T)option.cast((Object)(this.tcpNoDelay != 0 ? 1 : 0));
        }
        if (option == Options.READ_TIMEOUT) {
            return (T)option.cast((Object)this.readTimeout);
        }
        if (option == Options.WRITE_TIMEOUT) {
            return (T)option.cast((Object)this.writeTimeout);
        }
        if (option == Options.CONNECTION_HIGH_WATER) {
            return (T)option.cast((Object)QueuedNioTcpServer.getHighWater(this.connectionStatus));
        }
        if (option == Options.CONNECTION_LOW_WATER) {
            return (T)option.cast((Object)QueuedNioTcpServer.getLowWater(this.connectionStatus));
        }
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Comparable<Boolean> old;
        if (option == Options.REUSE_ADDRESSES) {
            old = this.socket.getReuseAddress();
            this.socket.setReuseAddress((Boolean)Options.REUSE_ADDRESSES.cast(value, (Object)Boolean.FALSE));
        } else if (option == Options.RECEIVE_BUFFER) {
            old = this.socket.getReceiveBufferSize();
            int newValue = (Integer)Options.RECEIVE_BUFFER.cast(value, (Object)65536);
            if (newValue < 1) {
                throw Log.log.optionOutOfRange("RECEIVE_BUFFER");
            }
            this.socket.setReceiveBufferSize(newValue);
        } else if (option == Options.SEND_BUFFER) {
            int newValue = (Integer)Options.SEND_BUFFER.cast(value, (Object)65536);
            if (newValue < 1) {
                throw Log.log.optionOutOfRange("SEND_BUFFER");
            }
            int oldValue = sendBufferUpdater.getAndSet(this, newValue);
            old = oldValue == -1 ? null : Integer.valueOf(oldValue);
        } else if (option == Options.KEEP_ALIVE) {
            old = keepAliveUpdater.getAndSet(this, (Boolean)Options.KEEP_ALIVE.cast(value, (Object)Boolean.FALSE) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_OOB_INLINE) {
            old = oobInlineUpdater.getAndSet(this, (Boolean)Options.TCP_OOB_INLINE.cast(value, (Object)Boolean.FALSE) != false ? 1 : 0) != 0;
        } else if (option == Options.TCP_NODELAY) {
            old = tcpNoDelayUpdater.getAndSet(this, (Boolean)Options.TCP_NODELAY.cast(value, (Object)Boolean.FALSE) != false ? 1 : 0) != 0;
        } else if (option == Options.READ_TIMEOUT) {
            old = readTimeoutUpdater.getAndSet(this, (Integer)Options.READ_TIMEOUT.cast(value, (Object)0));
        } else if (option == Options.WRITE_TIMEOUT) {
            old = writeTimeoutUpdater.getAndSet(this, (Integer)Options.WRITE_TIMEOUT.cast(value, (Object)0));
        } else if (option == Options.CONNECTION_HIGH_WATER) {
            old = QueuedNioTcpServer.getHighWater(this.updateWaterMark(-1, (Integer)Options.CONNECTION_HIGH_WATER.cast(value, (Object)Integer.MAX_VALUE)));
        } else if (option == Options.CONNECTION_LOW_WATER) {
            old = QueuedNioTcpServer.getLowWater(this.updateWaterMark((Integer)Options.CONNECTION_LOW_WATER.cast(value, (Object)Integer.MAX_VALUE), -1));
        } else {
            return null;
        }
        return (T)option.cast((Object)old);
    }

    private long updateWaterMark(int reqNewLowWater, int reqNewHighWater) {
        int newHighWater;
        int newLowWater;
        long newVal;
        long oldVal;
        assert (reqNewLowWater != -1 || reqNewHighWater != -1);
        assert (reqNewLowWater == -1 || reqNewHighWater == -1 || reqNewLowWater <= reqNewHighWater);
        do {
            oldVal = this.connectionStatus;
            int oldLowWater = QueuedNioTcpServer.getLowWater(oldVal);
            int oldHighWater = QueuedNioTcpServer.getHighWater(oldVal);
            newLowWater = reqNewLowWater == -1 ? oldLowWater : reqNewLowWater;
            int n = newHighWater = reqNewHighWater == -1 ? oldHighWater : reqNewHighWater;
            if (reqNewLowWater != -1 && newLowWater > newHighWater) {
                newHighWater = newLowWater;
            } else if (reqNewHighWater != -1 && newHighWater < newLowWater) {
                newLowWater = newHighWater;
            }
            if (oldLowWater != newLowWater || oldHighWater != newHighWater) continue;
            return oldVal;
        } while (!connectionStatusUpdater.compareAndSet(this, oldVal, newVal = (long)newLowWater << 0 | (long)newHighWater << 31));
        return oldVal;
    }

    private static int getHighWater(long value) {
        return (int)((value & 0x3FFFFFFF80000000L) >> 31);
    }

    private static int getLowWater(long value) {
        return (int)((value & Integer.MAX_VALUE) >> 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioSocketStreamConnection accept() throws IOException {
        block13: {
            WorkerThread current = WorkerThread.getCurrent();
            if (current == null) {
                return null;
            }
            BlockingQueue<SocketChannel> socketChannels = this.acceptQueues.get(current.getNumber());
            boolean ok = false;
            try {
                NioSocketStreamConnection nioSocketStreamConnection;
                block14: {
                    SocketChannel accepted = (SocketChannel)socketChannels.poll();
                    if (accepted == null) break block13;
                    try {
                        accepted.configureBlocking(false);
                        Socket socket = accepted.socket();
                        socket.setKeepAlive(this.keepAlive != 0);
                        socket.setOOBInline(this.oobInline != 0);
                        socket.setTcpNoDelay(this.tcpNoDelay != 0);
                        int sendBuffer = this.sendBuffer;
                        if (sendBuffer > 0) {
                            socket.setSendBufferSize(sendBuffer);
                        }
                        SelectionKey selectionKey = current.registerChannel(accepted);
                        NioSocketStreamConnection newConnection = new NioSocketStreamConnection(current, selectionKey, this.handle);
                        newConnection.setOption(Options.READ_TIMEOUT, this.readTimeout);
                        newConnection.setOption(Options.WRITE_TIMEOUT, this.writeTimeout);
                        ok = true;
                        nioSocketStreamConnection = newConnection;
                        if (ok) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!ok) {
                                IoUtils.safeClose((Closeable)accepted);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            NioSocketStreamConnection nioSocketStreamConnection2 = null;
                            return nioSocketStreamConnection2;
                        }
                        finally {
                        }
                    }
                    IoUtils.safeClose((Closeable)accepted);
                }
                return nioSocketStreamConnection;
            }
            finally {
                if (!ok) {
                    this.handle.freeConnection();
                }
            }
        }
        return null;
    }

    public String toString() {
        return String.format("TCP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    public ChannelListener<? super QueuedNioTcpServer> getAcceptListener() {
        return this.acceptListener;
    }

    public void setAcceptListener(ChannelListener<? super QueuedNioTcpServer> acceptListener) {
        this.acceptListener = acceptListener;
    }

    public ChannelListener.Setter<QueuedNioTcpServer> getAcceptSetter() {
        return new AcceptListenerSettable.Setter((AcceptListenerSettable)this);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        SocketAddress address = this.getLocalAddress();
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    public void suspendAccepts() {
        this.handle.suspend(0);
    }

    public void resumeAccepts() {
        this.handle.resume(16);
    }

    public boolean isAcceptResumed() {
        return this.handle.isResumed(16);
    }

    public void wakeupAccepts() {
        Log.tcpServerLog.logf(FQCN, Logger.Level.TRACE, null, "Wake up accepts on %s", this);
        this.resumeAccepts();
        this.handle.wakeup(16);
    }

    public void awaitAcceptable() throws IOException {
        throw Log.log.unsupported("awaitAcceptable");
    }

    public void awaitAcceptable(long time, TimeUnit timeUnit) throws IOException {
        throw Log.log.unsupported("awaitAcceptable");
    }

    @Deprecated
    public XnioExecutor getAcceptThread() {
        return this.getIoThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleReady() {
        block11: {
            try {
                SocketChannel accepted = this.channel.accept();
                boolean ok = false;
                if (accepted == null) break block11;
                try {
                    int hash;
                    SocketAddress localAddress = accepted.getLocalAddress();
                    if (localAddress instanceof InetSocketAddress) {
                        InetSocketAddress address = (InetSocketAddress)localAddress;
                        hash = address.getAddress().hashCode() * 23 + address.getPort();
                    } else {
                        hash = localAddress instanceof LocalSocketAddress ? ((LocalSocketAddress)localAddress).getName().hashCode() : localAddress.hashCode();
                    }
                    SocketAddress remoteAddress = accepted.getRemoteAddress();
                    if (remoteAddress instanceof InetSocketAddress) {
                        InetSocketAddress address = (InetSocketAddress)remoteAddress;
                        hash = (address.getAddress().hashCode() * 23 + address.getPort()) * 23 + hash;
                    } else {
                        hash = remoteAddress instanceof LocalSocketAddress ? ((LocalSocketAddress)remoteAddress).getName().hashCode() * 23 + hash : localAddress.hashCode() * 23 + hash;
                    }
                    accepted.configureBlocking(false);
                    Socket socket = accepted.socket();
                    socket.setKeepAlive(this.keepAlive != 0);
                    socket.setOOBInline(this.oobInline != 0);
                    socket.setTcpNoDelay(this.tcpNoDelay != 0);
                    int sendBuffer = this.sendBuffer;
                    if (sendBuffer > 0) {
                        socket.setSendBufferSize(sendBuffer);
                    }
                    WorkerThread ioThread = this.worker.getIoThread(hash);
                    SelectionKey selectionKey = ioThread.registerChannel(accepted);
                    NioSocketStreamConnection newConnection = new NioSocketStreamConnection(ioThread, selectionKey, this.handle);
                    newConnection.setOption(Options.READ_TIMEOUT, this.readTimeout);
                    newConnection.setOption(Options.WRITE_TIMEOUT, this.writeTimeout);
                    ok = true;
                    int number = ioThread.getNumber();
                    BlockingQueue<SocketChannel> queue = this.acceptQueues.get(number);
                    queue.add(accepted);
                    ioThread.execute(this.acceptTask);
                }
                finally {
                    if (!ok) {
                        IoUtils.safeClose((Closeable)accepted);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

