/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.combine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.combine.BaseCombiningAlgFactory;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgFactory;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.combine.DenyOverridesPolicyAlg;
import org.jboss.security.xacml.sunxacml.combine.DenyOverridesRuleAlg;
import org.jboss.security.xacml.sunxacml.combine.FirstApplicablePolicyAlg;
import org.jboss.security.xacml.sunxacml.combine.FirstApplicableRuleAlg;
import org.jboss.security.xacml.sunxacml.combine.OnlyOneApplicablePolicyAlg;
import org.jboss.security.xacml.sunxacml.combine.OrderedDenyOverridesPolicyAlg;
import org.jboss.security.xacml.sunxacml.combine.OrderedDenyOverridesRuleAlg;
import org.jboss.security.xacml.sunxacml.combine.OrderedPermitOverridesPolicyAlg;
import org.jboss.security.xacml.sunxacml.combine.OrderedPermitOverridesRuleAlg;
import org.jboss.security.xacml.sunxacml.combine.PermitOverridesPolicyAlg;
import org.jboss.security.xacml.sunxacml.combine.PermitOverridesRuleAlg;

public class StandardCombiningAlgFactory
extends BaseCombiningAlgFactory {
    private static StandardCombiningAlgFactory factoryInstance = null;
    private static Set supportedAlgorithms = null;
    private static Set supportedAlgIds;
    private static final Logger logger;

    private StandardCombiningAlgFactory() {
        super(supportedAlgorithms);
    }

    private static void initAlgorithms() {
        logger.config("Initializing standard combining algorithms");
        supportedAlgorithms = new HashSet();
        supportedAlgIds = new HashSet();
        supportedAlgorithms.add(new DenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new DenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:deny-overrides");
        supportedAlgorithms.add(new OrderedDenyOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new OrderedDenyOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:ordered-deny-overrides");
        supportedAlgorithms.add(new PermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new PermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides");
        supportedAlgorithms.add(new OrderedPermitOverridesRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:ordered-permit-overrides");
        supportedAlgorithms.add(new OrderedPermitOverridesPolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:ordered-permit-overrides");
        supportedAlgorithms.add(new FirstApplicableRuleAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable");
        supportedAlgorithms.add(new FirstApplicablePolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable");
        supportedAlgorithms.add(new OnlyOneApplicablePolicyAlg());
        supportedAlgIds.add("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable");
        supportedAlgIds = Collections.unmodifiableSet(supportedAlgIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StandardCombiningAlgFactory getFactory() {
        if (factoryInstance != null) return factoryInstance;
        Class<StandardCombiningAlgFactory> clazz = StandardCombiningAlgFactory.class;
        synchronized (StandardCombiningAlgFactory.class) {
            if (factoryInstance != null) return factoryInstance;
            StandardCombiningAlgFactory.initAlgorithms();
            factoryInstance = new StandardCombiningAlgFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factoryInstance;
        }
    }

    public static CombiningAlgFactory getNewFactory() {
        StandardCombiningAlgFactory.getFactory();
        return new BaseCombiningAlgFactory(supportedAlgorithms);
    }

    public static Set getStandardAlgorithms(String xacmlVersion) throws UnknownIdentifierException {
        if (xacmlVersion.equals("urn:oasis:names:tc:xacml:1.0:policy") || xacmlVersion.equals("urn:oasis:names:tc:xacml:2.0:policy:schema:os")) {
            return supportedAlgIds;
        }
        throw new UnknownIdentifierException("Unknown XACML version: " + xacmlVersion);
    }

    public void addAlgorithm(CombiningAlgorithm alg) {
        throw new UnsupportedOperationException("a standard factory cannot support new algorithms");
    }

    static {
        logger = Logger.getLogger(StandardCombiningAlgFactory.class.getName());
    }
}

