/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments;

import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public class LoggingDependencyDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier[] LOGGING_MODULES = new ModuleIdentifier[]{ModuleIdentifier.create((String)"org.jboss.logging"), ModuleIdentifier.create((String)"org.apache.commons.logging"), ModuleIdentifier.create((String)"org.apache.log4j"), ModuleIdentifier.create((String)"org.slf4j"), ModuleIdentifier.create((String)"org.jboss.logging.jul-to-slf4j-stub")};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (ModuleIdentifier moduleId : LOGGING_MODULES) {
            try {
                LoggingLogger.ROOT_LOGGER.tracef("Adding module '%s' to deployment '%s'", moduleId, deploymentUnit.getName());
                moduleLoader.loadModule(moduleId);
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleId, false, false, false, false));
            }
            catch (ModuleLoadException ex) {
                LoggingLogger.ROOT_LOGGER.debugf("Module not found: %s", moduleId);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

