/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.connector.services.resourceadapters.ConnectionFactoryReferenceFactoryService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.deployment.MessagingXmlInstallDeploymentUnitProcessor;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigProperties;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSConnectionFactoryDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    private String interfaceName;
    private String className;
    private String resourceAdapter;
    private String user;
    private String password;
    private String clientId;
    private boolean transactional;
    private int maxPoolSize;
    private int minPoolSize;

    public JMSConnectionFactoryDefinitionInjectionSource(String jndiName) {
        super(jndiName);
    }

    void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    void setClassName(String className) {
        this.className = className;
    }

    void setResourceAdapter(String resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    void setUser(String user) {
        this.user = user;
    }

    void setPassword(String password) {
        this.password = password;
    }

    void setClientId(String clientId) {
        this.clientId = clientId;
    }

    void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        try {
            this.startedPooledConnectionFactory(context, this.jndiName, serviceBuilder, phaseContext.getServiceTarget(), deploymentUnit, injector);
        }
        catch (OperationFailedException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void startedPooledConnectionFactory(InjectionSource.ResolutionContext context, String name, ServiceBuilder<?> serviceBuilder, ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException, OperationFailedException {
        String managedConnectionPoolClassName;
        String string;
        String discoveryGroupName;
        HashMap<String, String> props = new HashMap<String, String>(this.properties);
        List<String> connectors = this.getConnectors(props);
        this.clearUnknownProperties(this.properties);
        ModelNode model = new ModelNode();
        for (String string2 : connectors) {
            model.get("connectors").add(string2);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            model.get((String)entry.getKey()).set((String)entry.getValue());
        }
        model.get(ConnectionFactoryAttributes.Pooled.MIN_POOL_SIZE.getName()).set(this.minPoolSize);
        model.get(ConnectionFactoryAttributes.Pooled.MAX_POOL_SIZE.getName()).set(this.maxPoolSize);
        if (this.user != null && !this.user.isEmpty()) {
            model.get(ConnectionFactoryAttributes.Pooled.USER.getName()).set(this.user);
        }
        if (this.password != null && !this.password.isEmpty()) {
            model.get(ConnectionFactoryAttributes.Pooled.PASSWORD.getName()).set(this.password);
        }
        if (this.clientId != null && !this.clientId.isEmpty()) {
            model.get(CommonAttributes.CLIENT_ID.getName()).set(this.clientId);
        }
        String string3 = discoveryGroupName = this.properties.containsKey(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()) ? (String)this.properties.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()) : null;
        if (discoveryGroupName != null) {
            model.get(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName()).set(discoveryGroupName);
        }
        String string4 = string = this.properties.containsKey(CommonAttributes.JGROUPS_CHANNEL.getName()) ? (String)this.properties.get(CommonAttributes.JGROUPS_CHANNEL.getName()) : null;
        if (string != null) {
            model.get(CommonAttributes.JGROUPS_CHANNEL.getName()).set(string);
        }
        String string5 = managedConnectionPoolClassName = this.properties.containsKey(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()) ? (String)this.properties.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()) : null;
        if (managedConnectionPoolClassName != null) {
            model.get(ConnectionFactoryAttributes.Pooled.MANAGED_CONNECTION_POOL.getName()).set(managedConnectionPoolClassName);
        }
        Boolean enlistmentTrace = this.properties.containsKey(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName()) ? Boolean.valueOf((String)this.properties.get(ConnectionFactoryAttributes.Pooled.ENLISTMENT_TRACE.getName())) : null;
        List<PooledConnectionFactoryConfigProperties> adapterParams = this.getAdapterParams(model);
        String txSupport = this.transactional ? "XATransaction" : "NoTransaction";
        String pcfName = JMSConnectionFactoryDefinitionInjectionSource.uniqueName(context, name);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)name);
        PooledConnectionFactoryService.installService(serviceTarget, pcfName, this.getActiveMQServerName(), connectors, discoveryGroupName, string, adapterParams, bindInfo, txSupport, this.minPoolSize, this.maxPoolSize, managedConnectionPoolClassName, enlistmentTrace, true);
        ServiceName referenceFactoryServiceName = ConnectionFactoryReferenceFactoryService.SERVICE_NAME_BASE.append(bindInfo.getBinderServiceName());
        serviceBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, injector);
        String managementName = JMSConnectionFactoryDefinitionInjectionSource.managementName(context, name);
        PathElement serverElement = PathElement.pathElement((String)"server", (String)this.getActiveMQServerName());
        DeploymentResourceSupport deploymentResourceSupport = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        deploymentResourceSupport.getDeploymentSubModel("messaging-activemq", serverElement);
        PathElement pcfPath = PathElement.pathElement((String)"pooled-connection-factory", (String)managementName);
        PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{serverElement, pcfPath});
        MessagingXmlInstallDeploymentUnitProcessor.createDeploymentSubModel(registration, deploymentUnit);
        PooledConnectionFactoryConfigurationRuntimeHandler.INSTANCE.registerResource(this.getActiveMQServerName(), managementName, model);
    }

    private List<String> getConnectors(Map<String, String> props) {
        ArrayList<String> connectors = new ArrayList<String>();
        if (props.containsKey("connectors")) {
            String connectorsStr = (String)this.properties.remove("connectors");
            for (String s : connectorsStr.split(",")) {
                String connector = s.trim();
                if (connector.isEmpty()) continue;
                connectors.add(connector);
            }
        }
        return connectors;
    }

    void clearUnknownProperties(Map<String, String> props) {
        Set<String> attributeNames = PooledConnectionFactoryDefinition.getAttributesMap().keySet();
        Iterator<Map.Entry<String, String>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String value = entry.getKey();
            if (value == null || "".equals(value)) {
                it.remove();
                continue;
            }
            if (attributeNames.contains(entry.getKey())) continue;
            MessagingLogger.ROOT_LOGGER.unknownPooledConnectionFactoryAttribute(entry.getKey());
            it.remove();
        }
    }

    private static String uniqueName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder uniqueName = new StringBuilder();
        return uniqueName.append(context.getApplicationName() + "_").append(JMSConnectionFactoryDefinitionInjectionSource.managementName(context, jndiName)).toString();
    }

    private static String managementName(InjectionSource.ResolutionContext context, String jndiName) {
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append(context.getModuleName() + "_");
        if (context.getComponentName() != null) {
            uniqueName.append(context.getComponentName() + "_");
        }
        return uniqueName.append(jndiName.replace(':', '_')).toString();
    }

    private List<PooledConnectionFactoryConfigProperties> getAdapterParams(ModelNode model) {
        Map<String, ConnectionFactoryAttribute> attributes = PooledConnectionFactoryDefinition.getAttributesMap();
        ArrayList<PooledConnectionFactoryConfigProperties> props = new ArrayList<PooledConnectionFactoryConfigProperties>();
        for (Property property : model.asPropertyList()) {
            ConnectionFactoryAttribute attribute = attributes.get(property.getName());
            if (attribute.getPropertyName() == null) continue;
            props.add(new PooledConnectionFactoryConfigProperties(attribute.getPropertyName(), property.getValue().asString(), attribute.getClassType()));
        }
        return props;
    }

    private String getActiveMQServerName() {
        return this.properties.containsKey("server") ? (String)this.properties.get("server") : "default";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JMSConnectionFactoryDefinitionInjectionSource that = (JMSConnectionFactoryDefinitionInjectionSource)((Object)o);
        if (this.maxPoolSize != that.maxPoolSize) {
            return false;
        }
        if (this.minPoolSize != that.minPoolSize) {
            return false;
        }
        if (this.transactional != that.transactional) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.interfaceName != null ? !this.interfaceName.equals(that.interfaceName) : that.interfaceName != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.resourceAdapter != null ? !this.resourceAdapter.equals(that.resourceAdapter) : that.resourceAdapter != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.interfaceName != null ? this.interfaceName.hashCode() : 0);
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.resourceAdapter != null ? this.resourceAdapter.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.transactional ? 1 : 0);
        result = 31 * result + this.maxPoolSize;
        result = 31 * result + this.minPoolSize;
        return result;
    }
}

