/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.threads.AtomicArray;

public class BalancingExecutor
implements Executor {
    private volatile Executor[] executors = null;
    private final AtomicInteger seq = new AtomicInteger();
    private final Lock writeLock = new ReentrantLock();
    private static final AtomicArray<BalancingExecutor, Executor> executorsUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(BalancingExecutor.class, Executor[].class, "executors"), new AtomicArray.Creator<Executor>(){

        public Executor[] create(int len) {
            return new Executor[len];
        }
    });

    public BalancingExecutor() {
        executorsUpdater.clear(this);
    }

    public BalancingExecutor(Executor ... executors) {
        if (executors != null && executors.length > 0) {
            Executor[] clone = (Executor[])executors.clone();
            for (int i = 0; i < clone.length; ++i) {
                if (clone[i] != null) continue;
                throw new NullPointerException("executor at index " + i + " is null");
            }
            executorsUpdater.set(this, (Executor[])clone);
        } else {
            executorsUpdater.clear(this);
        }
    }

    @Override
    public void execute(Runnable command) throws RejectedExecutionException {
        Executor[] executors = this.executors;
        int len = executors.length;
        if (len == 0) {
            throw new RejectedExecutionException("No executors available to run task");
        }
        executors[this.seq.getAndIncrement() % len].execute(command);
    }

    public void clear() {
        executorsUpdater.clear(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutor(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        Lock lock = this.writeLock;
        lock.lock();
        try {
            executorsUpdater.add(this, executor);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutor(Executor executor) {
        if (executor == null) {
            return;
        }
        Lock lock = this.writeLock;
        lock.lock();
        try {
            executorsUpdater.remove(this, executor, true);
        }
        finally {
            lock.unlock();
        }
    }
}

