/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.metadata.common.ejb.IAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;
import org.jboss.metadata.merge.javaee.spec.MessageDestinationsMetaDataMerger;
import org.jboss.metadata.merge.javaee.spec.SecurityRolesMetaDataMerger;
import org.jboss.metadata.merge.javaee.support.IdMetaDataImplMerger;

public class JBossAssemblyDescriptorMetaData
extends IdMetaDataImpl
implements IAssemblyDescriptorMetaData {
    private static final long serialVersionUID = 5638920200035141015L;
    private SecurityRolesMetaData securityRoles;
    private MethodPermissionsMetaData methodPermissions;
    private ContainerTransactionsMetaData containerTransactions;
    private InterceptorBindingsMetaData interceptorBindings;
    private MessageDestinationsMetaData messageDestinations;
    private ExcludeListMetaData excludeList;
    private ApplicationExceptionsMetaData applicationExceptions;

    @Override
    public SecurityRoleMetaData getSecurityRole(String roleName) {
        return (SecurityRoleMetaData)this.securityRoles.get(roleName);
    }

    @Override
    public SecurityRolesMetaData getSecurityRoles() {
        return this.securityRoles;
    }

    @Override
    public void setSecurityRoles(SecurityRolesMetaData securityRoles) {
        if (securityRoles == null) {
            throw new IllegalArgumentException("Null securityRoles");
        }
        this.securityRoles = securityRoles;
    }

    @Override
    public MethodPermissionsMetaData getMethodPermissions() {
        return this.methodPermissions;
    }

    @Override
    public void setMethodPermissions(MethodPermissionsMetaData methodPermissions) {
        if (methodPermissions == null) {
            throw new IllegalArgumentException("Null methodPermissions");
        }
        this.methodPermissions = methodPermissions;
    }

    @Override
    public MethodPermissionsMetaData getMethodPermissionsByEjbName(String ejbName) {
        if (ejbName == null) {
            throw new IllegalArgumentException("Null ejbName");
        }
        if (this.methodPermissions == null) {
            return null;
        }
        return this.methodPermissions.getMethodPermissionsByEjbName(ejbName);
    }

    @Override
    public ContainerTransactionsMetaData getContainerTransactions() {
        return this.containerTransactions;
    }

    @Override
    public void setContainerTransactions(ContainerTransactionsMetaData containerTransactions) {
        if (containerTransactions == null) {
            throw new IllegalArgumentException("Null containerTransactions");
        }
        this.containerTransactions = containerTransactions;
    }

    @Override
    public ContainerTransactionsMetaData getContainerTransactionsByEjbName(String ejbName) {
        if (ejbName == null) {
            throw new IllegalArgumentException("Null ejbName");
        }
        if (this.containerTransactions == null) {
            return null;
        }
        return this.containerTransactions.getContainerTransactionsByEjbName(ejbName);
    }

    @Override
    public InterceptorBindingsMetaData getInterceptorBindings() {
        return this.interceptorBindings;
    }

    @Override
    public void setInterceptorBindings(InterceptorBindingsMetaData interceptorBindings) {
        if (interceptorBindings == null) {
            throw new IllegalArgumentException("Null interceptorBindings");
        }
        this.interceptorBindings = interceptorBindings;
    }

    @Override
    public ExcludeListMetaData getExcludeList() {
        return this.excludeList;
    }

    @Override
    public void setExcludeList(ExcludeListMetaData excludeList) {
        if (excludeList == null) {
            throw new IllegalArgumentException("Null excludeList");
        }
        this.excludeList = excludeList;
    }

    @Override
    public ExcludeListMetaData getExcludeListByEjbName(String ejbName) {
        if (ejbName == null) {
            throw new IllegalArgumentException("Null ejbName");
        }
        if (this.excludeList == null) {
            return null;
        }
        return this.excludeList.getExcludeListByEjbName(ejbName);
    }

    @Override
    public ApplicationExceptionsMetaData getApplicationExceptions() {
        return this.applicationExceptions;
    }

    @Override
    public void setApplicationExceptions(ApplicationExceptionsMetaData applicationExceptions) {
        if (applicationExceptions == null) {
            throw new IllegalArgumentException("Null applicationExceptions");
        }
        this.applicationExceptions = applicationExceptions;
    }

    public Set<String> getSecurityRolePrincipals(String name) {
        if (this.securityRoles == null) {
            return null;
        }
        SecurityRoleMetaData securityRole = (SecurityRoleMetaData)this.securityRoles.get(name);
        if (securityRole == null) {
            return null;
        }
        return securityRole.getPrincipals();
    }

    @Deprecated
    public SecurityRolesMetaData getSecurityRolesByPrincipal(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("Null userName");
        }
        if (this.securityRoles == null) {
            return null;
        }
        return this.securityRoles.getSecurityRolesByPrincipal(userName);
    }

    public Set<String> getSecurityRoleNamesByPrincipal(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("Null userName");
        }
        if (this.securityRoles == null) {
            return Collections.emptySet();
        }
        return this.securityRoles.getSecurityRoleNamesByPrincipal(userName);
    }

    public Map<String, Set<String>> getPrincipalVersusRolesMap() {
        if (this.securityRoles == null) {
            return null;
        }
        return this.securityRoles.getPrincipalVersusRolesMap();
    }

    @Override
    public MessageDestinationsMetaData getMessageDestinations() {
        return this.messageDestinations;
    }

    @Override
    public void setMessageDestinations(MessageDestinationsMetaData messageDestinations) {
        if (messageDestinations == null) {
            throw new IllegalArgumentException("Null messageDestinations");
        }
        this.messageDestinations = messageDestinations;
    }

    @Override
    public MessageDestinationMetaData getMessageDestination(String name) {
        if (this.messageDestinations == null) {
            return null;
        }
        return (MessageDestinationMetaData)this.messageDestinations.get(name);
    }

    public void merge(JBossAssemblyDescriptorMetaData override, AssemblyDescriptorMetaData original) {
        IdMetaDataImplMerger.merge((IdMetaDataImpl)this, (IdMetaDataImpl)override, (IdMetaDataImpl)original);
        JBossAssemblyDescriptorMetaData merged = this;
        if (override != null && override.applicationExceptions != null) {
            this.setApplicationExceptions(override.applicationExceptions);
        } else if (original != null && original.getApplicationExceptions() != null) {
            this.setApplicationExceptions(original.getApplicationExceptions());
        }
        if (override != null && override.containerTransactions != null) {
            this.setContainerTransactions(override.containerTransactions);
        } else if (original != null && original.getContainerTransactions() != null) {
            this.setContainerTransactions(original.getContainerTransactions());
        }
        if (override != null && override.excludeList != null) {
            this.setExcludeList(override.excludeList);
        } else if (original != null && original.getExcludeList() != null) {
            this.setExcludeList(original.getExcludeList());
        }
        if (override != null && override.interceptorBindings != null) {
            this.setInterceptorBindings(override.interceptorBindings);
        } else if (original != null && original.getInterceptorBindings() != null) {
            this.setInterceptorBindings(original.getInterceptorBindings());
        }
        if (override != null && override.methodPermissions != null) {
            this.setMethodPermissions(override.methodPermissions);
        } else if (original != null && original.getMethodPermissions() != null) {
            this.setMethodPermissions(original.getMethodPermissions());
        }
        SecurityRolesMetaData securityRolesMetaData = null;
        SecurityRolesMetaData jbossSecurityRolesMetaData = null;
        MessageDestinationsMetaData messageDestinationsMetaData = null;
        MessageDestinationsMetaData jbossMessageDestinationsMetaData = null;
        if (override != null) {
            jbossMessageDestinationsMetaData = override.getMessageDestinations();
            jbossSecurityRolesMetaData = override.getSecurityRoles();
        }
        if (original != null) {
            securityRolesMetaData = original.getSecurityRoles();
            messageDestinationsMetaData = original.getMessageDestinations();
        }
        if (jbossSecurityRolesMetaData == null || jbossSecurityRolesMetaData.isEmpty()) {
            if (securityRolesMetaData != null) {
                merged.setSecurityRoles(securityRolesMetaData);
            }
        } else {
            SecurityRolesMetaData mergedSecurityRolesMetaData = new SecurityRolesMetaData();
            SecurityRolesMetaDataMerger.merge((SecurityRolesMetaData)mergedSecurityRolesMetaData, (SecurityRolesMetaData)jbossSecurityRolesMetaData, (SecurityRolesMetaData)securityRolesMetaData);
            if (mergedSecurityRolesMetaData != null && !mergedSecurityRolesMetaData.isEmpty()) {
                merged.setSecurityRoles(mergedSecurityRolesMetaData);
            }
        }
        if (jbossMessageDestinationsMetaData == null || jbossMessageDestinationsMetaData.isEmpty()) {
            if (messageDestinationsMetaData != null && jbossMessageDestinationsMetaData == null) {
                merged.setMessageDestinations(messageDestinationsMetaData);
            }
        } else {
            MessageDestinationsMetaData mergedMessageDestinationsMetaData = new MessageDestinationsMetaData();
            MessageDestinationsMetaDataMerger.merge((MessageDestinationsMetaData)mergedMessageDestinationsMetaData, (MessageDestinationsMetaData)jbossMessageDestinationsMetaData, (MessageDestinationsMetaData)messageDestinationsMetaData);
            if (mergedMessageDestinationsMetaData != null && !mergedMessageDestinationsMetaData.isEmpty()) {
                merged.setMessageDestinations(mergedMessageDestinationsMetaData);
            }
        }
    }

    public void merge(JBossAssemblyDescriptorMetaData override, IAssemblyDescriptorMetaData assembly) {
        AssemblyDescriptorMetaData original = (AssemblyDescriptorMetaData)assembly;
        this.merge(override, original);
    }

    public void merge(JBossAssemblyDescriptorMetaData override, JBossAssemblyDescriptorMetaData original) {
        IdMetaDataImplMerger.merge((IdMetaDataImpl)this, (IdMetaDataImpl)override, (IdMetaDataImpl)original);
        ApplicationExceptionsMetaData originalExceptions = null;
        SecurityRolesMetaData originalRoles = null;
        MethodPermissionsMetaData originalPermissions = null;
        ContainerTransactionsMetaData originalTransactions = null;
        InterceptorBindingsMetaData originalInterceptors = null;
        MessageDestinationsMetaData originalDestinations = null;
        ExcludeListMetaData originalExclude = null;
        if (original != null) {
            originalExceptions = original.applicationExceptions;
            originalRoles = original.securityRoles;
            originalPermissions = original.methodPermissions;
            originalTransactions = original.containerTransactions;
            originalInterceptors = original.interceptorBindings;
            originalDestinations = original.messageDestinations;
            originalExclude = original.excludeList;
        }
        ApplicationExceptionsMetaData overrideExceptions = null;
        SecurityRolesMetaData overrideRoles = null;
        MethodPermissionsMetaData overridePermissions = null;
        ContainerTransactionsMetaData overrideTransactions = null;
        InterceptorBindingsMetaData overrideInterceptors = null;
        MessageDestinationsMetaData overrideDestinations = null;
        ExcludeListMetaData overrideExclude = null;
        if (override != null) {
            overrideExceptions = override.applicationExceptions;
            overrideRoles = override.securityRoles;
            overridePermissions = override.methodPermissions;
            overrideTransactions = override.containerTransactions;
            overrideInterceptors = override.interceptorBindings;
            overrideDestinations = override.messageDestinations;
            overrideExclude = override.excludeList;
        }
        if (originalExceptions != null || overrideExceptions != null) {
            if (this.applicationExceptions == null) {
                this.applicationExceptions = new ApplicationExceptionsMetaData();
            }
            this.applicationExceptions.merge(overrideExceptions, originalExceptions);
        }
        if (originalRoles != null || overrideRoles != null) {
            if (this.securityRoles == null) {
                this.securityRoles = new SecurityRolesMetaData();
            }
            SecurityRolesMetaDataMerger.merge((SecurityRolesMetaData)this.securityRoles, (SecurityRolesMetaData)overrideRoles, (SecurityRolesMetaData)originalRoles);
        }
        if (originalPermissions != null || overridePermissions != null) {
            if (this.methodPermissions == null) {
                this.methodPermissions = new MethodPermissionsMetaData();
            }
            this.methodPermissions.merge(overridePermissions, originalPermissions);
        }
        if (originalTransactions != null || overrideTransactions != null) {
            if (this.containerTransactions == null) {
                this.containerTransactions = new ContainerTransactionsMetaData();
            }
            this.containerTransactions.merge(overrideTransactions, originalTransactions);
        }
        if (originalInterceptors != null || overrideInterceptors != null) {
            if (this.interceptorBindings == null) {
                this.interceptorBindings = new InterceptorBindingsMetaData();
            }
            this.interceptorBindings.merge(overrideInterceptors, originalInterceptors);
        }
        if (originalDestinations != null || overrideDestinations != null) {
            if (this.messageDestinations == null) {
                this.messageDestinations = new MessageDestinationsMetaData();
            }
            MessageDestinationsMetaDataMerger.merge((MessageDestinationsMetaData)this.messageDestinations, (MessageDestinationsMetaData)overrideDestinations, (MessageDestinationsMetaData)originalDestinations);
        }
        if (originalExclude != null || overrideExclude != null) {
            if (this.excludeList == null) {
                this.excludeList = new ExcludeListMetaData();
            }
            this.excludeList.merge(overrideExclude, originalExclude);
        }
    }
}

