/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AttributeLocationProvider;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.Resource;

public abstract class Instance<L, T extends AttributeLocationProvider<L>>
extends AttributeLocationProvider<L> {
    private final T type;
    private Resource<L> resource;

    protected Instance(ID id, Name name, AttributeLocation<L> attributeLocation, T type) {
        super(id, name, attributeLocation);
        this.type = type;
    }

    protected Instance(Instance<L, T> original, boolean disown) {
        this(original.getID(), original.getName(), original.getAttributeLocation(), original.type);
        this.resource = disown ? null : original.resource;
    }

    public T getType() {
        return this.type;
    }

    public void setResource(Resource<L> resource) {
        if (this.resource != null) {
            throw new IllegalStateException(String.format("Instance [%s] is already assigned to [%s]. Cannot reassign to [%s]", this, this.resource, resource));
        }
        this.resource = resource;
    }

    public Resource<L> getResource() {
        return this.resource;
    }
}

