/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;

public class StaticClaimsHandler
implements ClaimsHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(StaticClaimsHandler.class);
    private Map<String, String> globalClaims;

    public void setGlobalClaims(Map<String, String> globalClaims) {
        this.globalClaims = globalClaims;
    }

    public Map<String, String> getGlobalClaims() {
        return this.globalClaims;
    }

    @Override
    public List<URI> getSupportedClaimTypes() {
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (String uri : this.getGlobalClaims().keySet()) {
            try {
                uriList.add(new URI(uri));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return uriList;
    }

    @Override
    public ProcessedClaimCollection retrieveClaimValues(ClaimCollection claims, ClaimsParameters parameters) {
        ProcessedClaimCollection claimsColl = new ProcessedClaimCollection();
        for (Claim claim : claims) {
            if (this.getGlobalClaims().keySet().contains(claim.getClaimType().toString())) {
                ProcessedClaim c = new ProcessedClaim();
                c.setClaimType(claim.getClaimType());
                c.setPrincipal(parameters.getPrincipal());
                c.addValue(this.getGlobalClaims().get(claim.getClaimType().toString()));
                claimsColl.add(c);
                continue;
            }
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.finer("Unsupported claim: " + claim.getClaimType());
        }
        return claimsColl;
    }
}

