/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;

public class BeginInvalidationCommand
extends InvalidateCommand {
    private static final Field commandInvocationIdField;
    private static final Method generateIdMethod;
    private Object sessionTransactionId;

    public BeginInvalidationCommand() {
    }

    public BeginInvalidationCommand(CacheNotifier notifier, Set<Flag> flags, Object[] keys, Address address, Object sessionTransactionId) {
        this.notifier = notifier;
        this.flags = flags;
        this.keys = keys;
        this.sessionTransactionId = sessionTransactionId;
        if (commandInvocationIdField != null) {
            try {
                commandInvocationIdField.set((Object)this, generateIdMethod.invoke(null, address));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public Object getSessionTransactionId() {
        return this.sessionTransactionId;
    }

    public Object[] getParameters() {
        Object commandInvocationId = null;
        if (commandInvocationIdField != null) {
            try {
                commandInvocationId = commandInvocationIdField.get((Object)this);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{this.flags, this.sessionTransactionId, commandInvocationId, 0};
        }
        if (this.keys.length == 1) {
            return new Object[]{this.flags, this.sessionTransactionId, commandInvocationId, 1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 4];
        retval[0] = this.flags;
        retval[1] = this.sessionTransactionId;
        retval[2] = commandInvocationId;
        retval[3] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 4, this.keys.length);
        return retval;
    }

    public void setParameters(int commandId, Object[] args) {
        if (commandId != 122) {
            throw new IllegalStateException("Invalid method id");
        }
        this.flags = (Set)args[0];
        this.sessionTransactionId = args[1];
        Object commandInvocationId = args[2];
        if (commandInvocationIdField != null) {
            try {
                commandInvocationIdField.set((Object)this, commandInvocationId);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        int size = (Integer)args[3];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[4];
        } else if (size > 0) {
            System.arraycopy(args, 4, this.keys, 0, size);
        }
    }

    public byte getCommandId() {
        return 122;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof BeginInvalidationCommand) {
            BeginInvalidationCommand bic = (BeginInvalidationCommand)((Object)o);
            return EqualsHelper.equals((Object)this.sessionTransactionId, (Object)bic.sessionTransactionId);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + (this.sessionTransactionId == null ? 0 : this.sessionTransactionId.hashCode());
    }

    public String toString() {
        return "BeginInvalidateCommand{keys=" + Arrays.toString(this.keys) + ", sessionTransactionId=" + this.sessionTransactionId + '}';
    }

    static {
        Field commandInvocationId = null;
        Method generateId = null;
        try {
            commandInvocationId = AbstractDataWriteCommand.class.getDeclaredField("commandInvocationId");
            commandInvocationId.setAccessible(true);
            Class<?> commandInvocationIdClass = Class.forName("org.infinispan.commands.CommandInvocationId");
            generateId = commandInvocationIdClass.getMethod("generateId", Address.class);
        }
        catch (NoSuchFieldException commandInvocationIdClass) {
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        commandInvocationIdField = commandInvocationId;
        generateIdMethod = generateId;
    }
}

