/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.resolvers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.injection.ReferenceResolver;

public abstract class AbstractReferenceResolver<A extends Annotation>
implements ReferenceResolver {
    private final Class<A> annotationClass;

    public AbstractReferenceResolver(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw Messages.MESSAGES.annotationClassCannotBeNull();
        }
        this.annotationClass = annotationClass;
    }

    @Override
    public final String resolve(AccessibleObject accessibleObject) {
        if (!this.canResolve(accessibleObject)) {
            throw Messages.MESSAGES.cannotResolve(accessibleObject);
        }
        if (accessibleObject.getClass().equals(Method.class)) {
            return this.resolveMethod((Method)accessibleObject);
        }
        return this.resolveField((Field)accessibleObject);
    }

    @Override
    public final boolean canResolve(AccessibleObject accessibleObject) {
        this.assertNotNull(accessibleObject);
        boolean isField = accessibleObject.getClass().equals(Field.class);
        boolean isMethod = accessibleObject.getClass().equals(Method.class);
        boolean hasAnnotation = accessibleObject.getAnnotation(this.annotationClass) != null;
        return (isField || isMethod) && hasAnnotation;
    }

    protected abstract String resolveMethod(Method var1);

    protected abstract String resolveField(Field var1);

    private void assertNotNull(AccessibleObject accessibleObject) {
        if (accessibleObject == null) {
            throw Messages.MESSAGES.accessibleObjectClassCannotBeNull();
        }
    }
}

