/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.CoreJBossASClient;
import org.hawkular.dmrclient.FailureException;
import org.hawkular.dmrclient.JBossASClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;

public class SecurityDomainJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_SECURITY = "security";
    public static final String SECURITY_DOMAIN = "security-domain";
    public static final String CACHE_TYPE = "cache-type";
    public static final String AUTHENTICATION = "authentication";
    public static final String LOGIN_MODULE = "login-module";
    public static final String LOGIN_MODULES = "login-modules";
    public static final String CLASSIC = "classic";
    public static final String CODE = "code";
    public static final String FLAG = "flag";
    public static final String MODULE_OPTIONS = "module-options";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DS_JNDI_NAME = "dsJndiName";
    public static final String PRINCIPALS_QUERY = "principalsQuery";
    public static final String ROLES_QUERY = "rolesQuery";
    public static final String HASH_ALGORITHM = "hashAlgorithm";
    public static final String HASH_ENCODING = "hashEncoding";

    public SecurityDomainJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isSecurityDomain(String securityDomainName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY);
        return null != this.findNodeInList(addr, haystack = SECURITY_DOMAIN, securityDomainName);
    }

    public void createNewSecureIdentitySecurityDomain72(String securityDomainName, String username, String password) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode addTopNode = SecurityDomainJBossASClient.createRequest("add", addr);
        addTopNode.get(CACHE_TYPE).set("default");
        Address authAddr = addr.clone().add(AUTHENTICATION, CLASSIC);
        ModelNode addAuthNode = SecurityDomainJBossASClient.createRequest("add", authAddr);
        Address loginAddr = authAddr.clone().add(LOGIN_MODULE, "SecureIdentity");
        ModelNode loginModule = SecurityDomainJBossASClient.createRequest("add", loginAddr);
        loginModule.get(CODE).set("SecureIdentity");
        loginModule.get(FLAG).set("required");
        ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
        moduleOptions.setEmptyList();
        this.addPossibleExpression(moduleOptions, USERNAME, username);
        this.addPossibleExpression(moduleOptions, PASSWORD, password);
        ModelNode batch = SecurityDomainJBossASClient.createBatchRequest(addTopNode, addAuthNode, loginModule);
        ModelNode results = this.execute(batch);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to create security domain [" + securityDomainName + "]");
        }
    }

    public void updateSecureIdentitySecurityDomainCredentials(String securityDomainName, String username, String password) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName, AUTHENTICATION, CLASSIC);
        ModelNode loginModule = new ModelNode();
        loginModule.get(CODE).set("SecureIdentity");
        loginModule.get(FLAG).set("required");
        ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
        moduleOptions.setEmptyList();
        this.addPossibleExpression(moduleOptions, USERNAME, username);
        this.addPossibleExpression(moduleOptions, PASSWORD, password);
        ModelNode loginModuleList = new ModelNode();
        loginModuleList.setEmptyList();
        loginModuleList.add(loginModule);
        ModelNode op = SecurityDomainJBossASClient.createRequest("write-attribute", addr);
        op.get("name").set(LOGIN_MODULES);
        op.get("value").set(loginModuleList);
        ModelNode results = this.execute(op);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to update credentials for security domain [" + securityDomainName + "]");
        }
    }

    private void addPossibleExpression(ModelNode node, String name, String value) {
        if (value != null && value.contains("${")) {
            node.add(name, new ModelNode(ModelType.EXPRESSION).set(new ValueExpression(value)));
        } else {
            node.add(name, value);
        }
    }

    public ModelNode getSecureIdentitySecurityDomainModuleOptions(String securityDomainName) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName, AUTHENTICATION, CLASSIC);
        ModelNode authResource = this.readResource(addr);
        List loginModules = authResource.get(LOGIN_MODULES).asList();
        for (ModelNode loginModule : loginModules) {
            if (!"SecureIdentity".equals(loginModule.get(CODE).asString())) continue;
            ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
            return moduleOptions;
        }
        return null;
    }

    public void createNewDatabaseServerSecurityDomain72(String securityDomainName, String dsJndiName, String principalsQuery, String rolesQuery, String hashAlgorithm, String hashEncoding) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode addTopNode = SecurityDomainJBossASClient.createRequest("add", addr);
        addTopNode.get(CACHE_TYPE).set("default");
        Address authAddr = addr.clone().add(AUTHENTICATION, CLASSIC);
        ModelNode addAuthNode = SecurityDomainJBossASClient.createRequest("add", authAddr);
        Address loginAddr = authAddr.clone().add(LOGIN_MODULE, "Database");
        ModelNode loginModule = SecurityDomainJBossASClient.createRequest("add", loginAddr);
        loginModule.get(CODE).set("Database");
        loginModule.get(FLAG).set("required");
        ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
        moduleOptions.setEmptyList();
        moduleOptions.add(DS_JNDI_NAME, dsJndiName);
        moduleOptions.add(PRINCIPALS_QUERY, principalsQuery);
        moduleOptions.add(ROLES_QUERY, rolesQuery);
        moduleOptions.add(HASH_ALGORITHM, null == hashAlgorithm ? "MD5" : hashAlgorithm);
        moduleOptions.add(HASH_ENCODING, null == hashEncoding ? "base64" : hashEncoding);
        ModelNode batch = SecurityDomainJBossASClient.createBatchRequest(addTopNode, addAuthNode, loginModule);
        ModelNode results = this.execute(batch);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to create security domain [" + securityDomainName + "]");
        }
    }

    public void removeSecurityDomain(String securityDomainName) throws Exception {
        if (!this.isSecurityDomain(securityDomainName)) {
            return;
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode removeSecurityDomainNode = SecurityDomainJBossASClient.createRequest("remove", addr);
        ModelNode results = this.execute(removeSecurityDomainNode);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to remove security domain [" + securityDomainName + "]");
        }
    }

    public void createNewSecurityDomain(String securityDomainName, LoginModuleRequest ... loginModules) throws Exception {
        CoreJBossASClient coreClient = new CoreJBossASClient(this.getModelControllerClient());
        String serverVersion = coreClient.getAppServerVersion();
        if (serverVersion.startsWith("7.2")) {
            this.createNewSecurityDomain72(securityDomainName, loginModules);
        } else {
            this.createNewSecurityDomain71(securityDomainName, loginModules);
        }
    }

    private void createNewSecurityDomain71(String securityDomainName, LoginModuleRequest ... loginModules) throws Exception {
        if (this.isSecurityDomain(securityDomainName)) {
            this.removeSecurityDomain(securityDomainName);
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode addTopNode = SecurityDomainJBossASClient.createRequest("add", addr);
        addTopNode.get(CACHE_TYPE).set("default");
        ModelNode addAuthNode = SecurityDomainJBossASClient.createRequest("add", addr.clone().add(AUTHENTICATION, CLASSIC));
        ModelNode loginModulesNode = addAuthNode.get(LOGIN_MODULES);
        int len = loginModules.length;
        for (int i = 0; i < len; ++i) {
            ModelNode loginModule = new ModelNode();
            loginModule.get(CODE).set(loginModules[i].getLoginModuleFQCN());
            loginModule.get(FLAG).set(loginModules[i].getFlagString());
            ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
            moduleOptions.setEmptyList();
            Map<String, String> moduleOptionProperties = loginModules[i].getModuleOptionProperties();
            if (null != moduleOptionProperties) {
                for (String key : moduleOptionProperties.keySet()) {
                    String value = moduleOptionProperties.get(key);
                    if (null == value) continue;
                    moduleOptions.add(key, value);
                }
            }
            loginModulesNode.add(loginModule);
        }
        ModelNode batch = SecurityDomainJBossASClient.createBatchRequest(addTopNode, addAuthNode);
        ModelNode results = this.execute(batch);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to create security domain [" + securityDomainName + "]");
        }
    }

    private void createNewSecurityDomain72(String securityDomainName, LoginModuleRequest ... loginModules) throws Exception {
        if (this.isSecurityDomain(securityDomainName)) {
            this.removeSecurityDomain(securityDomainName);
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, securityDomainName);
        ModelNode addTopNode = SecurityDomainJBossASClient.createRequest("add", addr);
        addTopNode.get(CACHE_TYPE).set("default");
        Address authAddr = addr.clone().add(AUTHENTICATION, CLASSIC);
        ModelNode addAuthNode = SecurityDomainJBossASClient.createRequest("add", authAddr);
        ModelNode[] steps = new ModelNode[loginModules.length + 2];
        steps[0] = addTopNode;
        steps[1] = addAuthNode;
        for (int i = 0; i < loginModules.length; ++i) {
            LoginModuleRequest moduleRequest = loginModules[i];
            Address loginAddr = authAddr.clone().add(LOGIN_MODULE, moduleRequest.getLoginModuleFQCN());
            ModelNode loginModule = SecurityDomainJBossASClient.createRequest("add", loginAddr);
            loginModule.get(CODE).set(moduleRequest.getLoginModuleFQCN());
            loginModule.get(FLAG).set(moduleRequest.getFlagString());
            ModelNode moduleOptions = loginModule.get(MODULE_OPTIONS);
            moduleOptions.setEmptyList();
            Map<String, String> moduleOptionProperties = moduleRequest.getModuleOptionProperties();
            if (null != moduleOptionProperties) {
                for (String key : moduleOptionProperties.keySet()) {
                    String value = moduleOptionProperties.get(key);
                    if (null == value) continue;
                    moduleOptions.add(key, value);
                }
            }
            steps[i + 2] = loginModule;
        }
        ModelNode batch = SecurityDomainJBossASClient.createBatchRequest(steps);
        ModelNode results = this.execute(batch);
        if (!SecurityDomainJBossASClient.isSuccess(results)) {
            throw new FailureException(results, "Failed to create security domain [" + securityDomainName + "]");
        }
    }

    public void flushSecurityDomainCache(String domain) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, domain);
        ModelNode request = SecurityDomainJBossASClient.createRequest("flush-cache", addr);
        ModelNode result = this.execute(request);
        if (!SecurityDomainJBossASClient.isSuccess(result)) {
            this.log.warn((Object)("Flushing " + domain + " failed - principals may be longer cached than expected"));
        }
    }

    public boolean securityDomainHasLoginModule(String domainName, String moduleName) throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_SECURITY, SECURITY_DOMAIN, domainName);
        addr.add(AUTHENTICATION, CLASSIC);
        addr.add(LOGIN_MODULE, moduleName);
        ModelNode request = SecurityDomainJBossASClient.createRequest("read-resource", addr);
        ModelNode response = this.execute(request);
        return SecurityDomainJBossASClient.isSuccess(response);
    }

    public static class LoginModuleRequest {
        private AppConfigurationEntry entry;

        public LoginModuleRequest(String loginModuleFQCN, AppConfigurationEntry.LoginModuleControlFlag flag, Map<String, String> moduleOptionProperties) {
            this.entry = new AppConfigurationEntry(loginModuleFQCN, flag, moduleOptionProperties);
        }

        public String getLoginModuleFQCN() {
            return this.entry.getLoginModuleName();
        }

        public AppConfigurationEntry.LoginModuleControlFlag getFlag() {
            return this.entry.getControlFlag();
        }

        public String getFlagString() {
            if (AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT.equals(this.entry.getControlFlag())) {
                return "sufficient";
            }
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUISITE.equals(this.entry.getControlFlag())) {
                return "requisite";
            }
            if (AppConfigurationEntry.LoginModuleControlFlag.REQUIRED.equals(this.entry.getControlFlag())) {
                return "required";
            }
            return "optional";
        }

        public Map<String, String> getModuleOptionProperties() {
            return this.entry.getOptions();
        }

        public String toString() {
            return "LoginModuleRequest [loginModuleFQCN=" + this.getLoginModuleFQCN() + ", flag=" + this.getFlag() + ", moduleOptionProperties=" + this.getModuleOptionProperties() + "]";
        }
    }
}

