/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.util.NoContent;

@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class ReaderProvider
implements MessageBodyReader<Reader>,
MessageBodyWriter<Reader> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(Reader.class);
    }

    public Reader readFrom(Class<Reader> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return new InputStreamReader(new ByteArrayInputStream(new byte[0]));
        }
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            return new InputStreamReader(entityStream);
        }
        return new InputStreamReader(entityStream, charset);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class.isAssignableFrom(type);
    }

    public long getSize(Reader inputStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Reader inputStream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            int c = inputStream.read();
            if (c == -1) {
                httpHeaders.putSingle((Object)"Content-Length", (Object)Integer.toString(0));
                entityStream.write(new byte[0]);
                return;
            }
            entityStream.write(c);
            while ((c = inputStream.read()) != -1) {
                entityStream.write(c);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

