/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.servlets.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.MetadataProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.identity.federation.api.saml.v2.metadata.KeyDescriptorMetaDataBuilder;
import org.picketlink.identity.federation.api.util.KeyUtil;
import org.picketlink.identity.federation.core.interfaces.IMetadataProvider;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.md.providers.MetadataProviderUtils;
import org.picketlink.identity.federation.core.saml.md.providers.SPMetadataProvider;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLMetadataWriter;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.metadata.AttributeAuthorityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.AuthnAuthorityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.PDPDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.RoleDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.web.servlets.saml.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataServletSP
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final PicketLinkLogger log = PicketLinkLoggerFactory.getLogger();
    private final boolean trace = log.isTraceEnabled();
    private String configFileLocation = "/WEB-INF/picketlink.xml";
    private transient MetadataProviderType metadataProviderType = null;
    private transient IMetadataProvider<?> metadataProvider = null;
    private transient EntitiesDescriptorType entitiesDescriptor;
    private transient EntityDescriptorType entityDescriptor;
    private String signingAlias = null;
    private String encryptingAlias = null;
    private TrustKeyManager keyManager;

    public void init(ServletConfig config) throws ServletException {
        String fileInjectionStr;
        InputStream is;
        super.init(config);
        ServletContext context = config.getServletContext();
        String configL = config.getInitParameter("configFile");
        if (StringUtil.isNotNull((String)configL)) {
            this.configFileLocation = configL;
        }
        if (this.trace) {
            log.trace("Config File Location=" + this.configFileLocation);
        }
        if ((is = context.getResourceAsStream(this.configFileLocation)) == null) {
            throw new ServletException("PL00018: Resource not found:" + this.configFileLocation + " missing");
        }
        this.signingAlias = config.getInitParameter("signingAlias");
        this.encryptingAlias = config.getInitParameter("encryptingAlias");
        PicketLinkType picketLinkType = MetadataProviderUtils.getPicketLinkConf(is);
        ProviderType providerType = MetadataProviderUtils.getProviderType(picketLinkType);
        this.metadataProviderType = providerType.getMetaDataProvider();
        String fqn = this.metadataProviderType.getClassName();
        Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), fqn);
        try {
            this.metadataProvider = (IMetadataProvider)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        List keyValues = this.metadataProviderType.getOption();
        HashMap<String, String> options = new HashMap<String, String>();
        if (keyValues != null) {
            for (KeyValueType kvt : keyValues) {
                options.put(kvt.getKey(), kvt.getValue());
            }
        }
        if (StringUtil.isNotNull((String)(fileInjectionStr = this.metadataProvider.requireFileInjection()))) {
            this.metadataProvider.injectFileStream(context.getResourceAsStream(fileInjectionStr));
        } else if (this.metadataProvider instanceof SPMetadataProvider) {
            ((SPMetadataProvider)this.metadataProvider).setPicketLinkConf(picketLinkType);
        }
        this.metadataProvider.init(options);
        Object metadata = this.metadataProvider.getMetaData();
        if (metadata instanceof EntitiesDescriptorType) {
            this.entitiesDescriptor = (EntitiesDescriptorType)metadata;
        } else if (metadata instanceof EntityDescriptorType) {
            this.entityDescriptor = (EntityDescriptorType)metadata;
        } else {
            throw new ServletException("PL00074: Parsing Error:Invalid metadata type");
        }
        KeyProviderType keyProvider = providerType.getKeyProvider();
        this.signingAlias = keyProvider.getSigningAlias();
        String keyManagerClassName = keyProvider.getClassName();
        if (keyManagerClassName == null) {
            throw new ServletException("PL00092: Null Value:KeyManager class name");
        }
        clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
        try {
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List<AuthPropertyType> authProperties = CoreConfigUtil.getKeyProviderProperties(keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            Certificate cert = this.keyManager.getCertificate(this.signingAlias);
            Element keyInfo = KeyUtil.getKeyInfo(cert);
            KeyDescriptorType keyDescriptor = KeyDescriptorMetaDataBuilder.createKeyDescriptor(keyInfo, null, 0, true, false);
            if (this.entitiesDescriptor != null) {
                this.updateKeyDescriptors(this.entitiesDescriptor, keyDescriptor);
            } else {
                this.updateKeyDescriptor(this.entityDescriptor, keyDescriptor);
            }
            if (this.encryptingAlias == null) {
                this.encryptingAlias = this.signingAlias;
            }
            cert = this.keyManager.getCertificate(this.encryptingAlias);
            keyInfo = KeyUtil.getKeyInfo(cert);
            keyDescriptor = KeyDescriptorMetaDataBuilder.createKeyDescriptor(keyInfo, null, 0, false, true);
            if (this.entitiesDescriptor != null) {
                this.updateKeyDescriptors(this.entitiesDescriptor, keyDescriptor);
            } else {
                this.updateKeyDescriptor(this.entityDescriptor, keyDescriptor);
                this.signAndAddAttribs(this.entityDescriptor);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType(JBossSAMLConstants.METADATA_MIME.get());
        ServletOutputStream os = resp.getOutputStream();
        try {
            XMLStreamWriter streamWriter = StaxUtil.getXMLStreamWriter((OutputStream)os);
            SAMLMetadataWriter writer = new SAMLMetadataWriter(streamWriter);
            if (this.entitiesDescriptor != null) {
                writer.writeEntitiesDescriptor(this.entitiesDescriptor);
            } else {
                writer.writeEntityDescriptor(this.entityDescriptor);
            }
        }
        catch (ProcessingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void signAndAddAttribs(EntityDescriptorType entityDescriptor) throws ServletException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter streamWriter = StaxUtil.getXMLStreamWriter((OutputStream)baos);
            SAMLMetadataWriter writer = new SAMLMetadataWriter(streamWriter);
            writer.writeEntityDescriptor(entityDescriptor);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            String feature = "";
            try {
                feature = "http://apache.org/xml/features/disallow-doctype-decl";
                documentBuilderFactory.setFeature(feature, true);
                feature = "http://xml.org/sax/features/external-general-entities";
                documentBuilderFactory.setFeature(feature, false);
                feature = "http://xml.org/sax/features/external-parameter-entities";
                documentBuilderFactory.setFeature(feature, false);
            }
            catch (ParserConfigurationException e) {
                throw log.parserFeatureNotSupported(feature);
            }
            Document doc = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray()));
            KeyPair keyPair = new KeyPair(null, this.keyManager.getSigningKey());
            Element spssoDesc = doc.getDocumentElement();
            XMLSignatureUtil.sign(spssoDesc, spssoDesc.getFirstChild(), keyPair, "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "", (X509Certificate)this.keyManager.getCertificate(this.signingAlias));
            entityDescriptor.setSignature(this.extractSignatureFromDoc(spssoDesc));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Element extractSignatureFromDoc(Element doc) {
        return (Element)doc.getFirstChild();
    }

    private String getStringFromDocument(Element doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    private void updateKeyDescriptors(EntitiesDescriptorType entityId, KeyDescriptorType keyD) {
        List<Object> entities = entityId.getEntityDescriptor();
        for (Object obj : entities) {
            this.updateKeyDescriptor((EntityDescriptorType)obj, keyD);
        }
    }

    private void updateKeyDescriptor(EntityDescriptorType entityD, KeyDescriptorType keyD) {
        List<EntityDescriptorType.EDTDescriptorChoiceType> objs = entityD.getChoiceType().get(0).getDescriptors();
        if (objs != null) {
            for (EntityDescriptorType.EDTDescriptorChoiceType choiceTypeDesc : objs) {
                SPSSODescriptorType spDescriptorType;
                RoleDescriptorType roleDescriptor;
                PDPDescriptorType pdpDescriptor;
                IDPSSODescriptorType idpDescriptor;
                AuthnAuthorityDescriptorType authnDescriptor;
                AttributeAuthorityDescriptorType attribDescriptor = choiceTypeDesc.getAttribDescriptor();
                if (attribDescriptor != null) {
                    attribDescriptor.addKeyDescriptor(keyD);
                }
                if ((authnDescriptor = choiceTypeDesc.getAuthnDescriptor()) != null) {
                    authnDescriptor.addKeyDescriptor(keyD);
                }
                if ((idpDescriptor = choiceTypeDesc.getIdpDescriptor()) != null) {
                    idpDescriptor.addKeyDescriptor(keyD);
                }
                if ((pdpDescriptor = choiceTypeDesc.getPdpDescriptor()) != null) {
                    pdpDescriptor.addKeyDescriptor(keyD);
                }
                if ((roleDescriptor = choiceTypeDesc.getRoleDescriptor()) != null) {
                    roleDescriptor.addKeyDescriptor(keyD);
                }
                if ((spDescriptorType = choiceTypeDesc.getSpDescriptor()) == null) continue;
                spDescriptorType.addKeyDescriptor(keyD);
            }
        }
    }
}

