/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.servlet.handlers.security.ServletSingleSignOnAuthenticationMechainism;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;

class SingleSignOnService
implements Service<SingleSignOnService> {
    private static final String AUTHENTICATION_MECHANISM_NAME = "SSO";
    private final String domain;
    private final String path;
    private final String cookieName;
    private final boolean httpOnly;
    private final boolean secure;
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<SingleSignOnManager> manager = new InjectedValue();

    SingleSignOnService(String domain, String path, boolean httpOnly, boolean secure, String cookieName) {
        this.domain = domain;
        this.path = path;
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.cookieName = cookieName;
    }

    public void start(StartContext startContext) {
        ServletSingleSignOnAuthenticationMechainism mechanism = new ServletSingleSignOnAuthenticationMechainism((SingleSignOnManager)this.manager.getValue());
        mechanism.setDomain(this.domain);
        mechanism.setPath(this.path);
        mechanism.setHttpOnly(this.httpOnly);
        mechanism.setSecure(this.secure);
        mechanism.setCookieName(this.cookieName);
        ((Host)this.host.getValue()).registerAdditionalAuthenticationMechanism(AUTHENTICATION_MECHANISM_NAME, (AuthenticationMechanism)mechanism);
    }

    public void stop(StopContext stopContext) {
        ((Host)this.host.getValue()).unregisterAdditionalAuthenticationMechanism(AUTHENTICATION_MECHANISM_NAME);
    }

    public SingleSignOnService getValue() {
        return this;
    }

    Injector<Host> getHost() {
        return this.host;
    }

    Injector<SingleSignOnManager> getSingleSignOnSessionManager() {
        return this.manager;
    }
}

