/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class MemoryMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final MemoryMXBeanAttributeHandler INSTANCE = new MemoryMXBeanAttributeHandler();

    private MemoryMXBeanAttributeHandler() {
        this.writeAttributeValidator.registerValidator("value", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            context.getResult().set("java.lang:type=Memory");
        } else if ("object-pending-finalization-count".equals(name)) {
            context.getResult().set(ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount());
        } else if ("heap-memory-usage".equals(name)) {
            ModelNode mu = PlatformMBeanUtil.getDetypedMemoryUsage(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
            context.getResult().set(mu);
        } else if ("non-heap-memory-usage".equals(name)) {
            ModelNode mu = PlatformMBeanUtil.getDetypedMemoryUsage(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
            context.getResult().set(mu);
        } else if ("verbose".equals(name)) {
            context.getResult().set(ManagementFactory.getMemoryMXBean().isVerbose());
        } else {
            if (MemoryResourceDefinition.MEMORY_METRICS.contains(name) || MemoryResourceDefinition.MEMORY_READ_WRITE_ATTRIBUTES.contains(name)) {
                throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
            }
            throw MemoryMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        if (!"verbose".equals(name)) {
            if (MemoryResourceDefinition.MEMORY_READ_WRITE_ATTRIBUTES.contains(name)) {
                throw PlatformMBeanLogger.ROOT_LOGGER.badWriteAttributeImpl(name);
            }
            throw MemoryMXBeanAttributeHandler.unknownAttribute(operation);
        }
        context.getServiceRegistry(true);
        ManagementFactory.getMemoryMXBean().setVerbose(operation.require("value").asBoolean());
    }
}

